/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseCommunicationBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IService;
import me.adaptive.arp.api.IServiceMethod;
import me.adaptive.arp.api.IServiceResultCallback;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.ServiceRequest;
import me.adaptive.arp.api.ServiceResultCallbackImpl;
import me.adaptive.arp.api.ServiceToken;

public class ServiceBridge
extends BaseCommunicationBridge
implements IService,
APIBridge {
    private IService delegate;

    public ServiceBridge(IService delegate) {
        this.delegate = delegate;
    }

    public final IService getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IService delegate) {
        this.delegate = delegate;
    }

    @Override
    public ServiceRequest getServiceRequest(ServiceToken serviceToken) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getServiceRequest...");
        }
        ServiceRequest result = null;
        if (this.delegate != null) {
            result = this.delegate.getServiceRequest(serviceToken);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getServiceRequest' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getServiceRequest'.");
        }
        return result;
    }

    @Override
    public ServiceToken getServiceToken(String serviceName, String endpointName, String functionName, IServiceMethod method) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getServiceToken...");
        }
        ServiceToken result = null;
        if (this.delegate != null) {
            result = this.delegate.getServiceToken(serviceName, endpointName, functionName, method);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getServiceToken' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getServiceToken'.");
        }
        return result;
    }

    @Override
    public ServiceToken getServiceTokenByUri(String uri) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getServiceTokenByUri...");
        }
        ServiceToken result = null;
        if (this.delegate != null) {
            result = this.delegate.getServiceTokenByUri(uri);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getServiceTokenByUri' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getServiceTokenByUri'.");
        }
        return result;
    }

    @Override
    public ServiceToken[] getServicesRegistered() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getServicesRegistered...");
        }
        ServiceToken[] result = null;
        if (this.delegate != null) {
            result = this.delegate.getServicesRegistered();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getServicesRegistered' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getServicesRegistered'.");
        }
        return result;
    }

    @Override
    public void invokeService(ServiceRequest serviceRequest, IServiceResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing invokeService...");
        }
        if (this.delegate != null) {
            this.delegate.invokeService(serviceRequest, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'invokeService' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'invokeService'.");
        }
    }

    @Override
    public boolean isServiceRegistered(String serviceName, String endpointName, String functionName, IServiceMethod method) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing isServiceRegistered...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.isServiceRegistered(serviceName, endpointName, functionName, method);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'isServiceRegistered' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'isServiceRegistered'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "getServiceRequest": {
                ServiceToken serviceToken0 = (ServiceToken)this.getJSONParser().fromJson(request.getParameters()[0], ServiceToken.class);
                ServiceRequest response0 = this.getServiceRequest(serviceToken0);
                if (response0 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response0);
                break;
            }
            case "getServiceToken": {
                String serviceName1 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                String endpointName1 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                String functionName1 = (String)this.getJSONParser().fromJson(request.getParameters()[2], String.class);
                IServiceMethod method1 = (IServiceMethod)((Object)this.getJSONParser().fromJson(request.getParameters()[3], IServiceMethod.class));
                ServiceToken response1 = this.getServiceToken(serviceName1, endpointName1, functionName1, method1);
                if (response1 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response1);
                break;
            }
            case "getServiceTokenByUri": {
                String uri2 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                ServiceToken response2 = this.getServiceTokenByUri(uri2);
                if (response2 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response2);
                break;
            }
            case "getServicesRegistered": {
                ServiceToken[] response3 = this.getServicesRegistered();
                if (response3 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response3);
                break;
            }
            case "invokeService": {
                ServiceRequest serviceRequest4 = (ServiceRequest)this.getJSONParser().fromJson(request.getParameters()[0], ServiceRequest.class);
                ServiceResultCallbackImpl callback4 = new ServiceResultCallbackImpl(request.getAsyncId());
                this.invokeService(serviceRequest4, callback4);
                break;
            }
            case "isServiceRegistered": {
                String serviceName5 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                String endpointName5 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                String functionName5 = (String)this.getJSONParser().fromJson(request.getParameters()[2], String.class);
                IServiceMethod method5 = (IServiceMethod)((Object)this.getJSONParser().fromJson(request.getParameters()[3], IServiceMethod.class));
                boolean response5 = this.isServiceRegistered(serviceName5, endpointName5, functionName5, method5);
                responseJSON = "" + response5;
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "ServiceBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.10.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

