/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSecurityBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.ISecurity;
import me.adaptive.arp.api.ISecurityResultCallback;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.SecureKeyPair;
import me.adaptive.arp.api.SecurityResultCallbackImpl;

public class SecurityBridge
extends BaseSecurityBridge
implements ISecurity,
APIBridge {
    private ISecurity delegate;

    public SecurityBridge(ISecurity delegate) {
        this.delegate = delegate;
    }

    public final ISecurity getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(ISecurity delegate) {
        this.delegate = delegate;
    }

    @Override
    public void deleteSecureKeyValuePairs(String[] keys, String publicAccessName, ISecurityResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing deleteSecureKeyValuePairs...");
        }
        if (this.delegate != null) {
            this.delegate.deleteSecureKeyValuePairs(keys, publicAccessName, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'deleteSecureKeyValuePairs' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'deleteSecureKeyValuePairs'.");
        }
    }

    @Override
    public void getSecureKeyValuePairs(String[] keys, String publicAccessName, ISecurityResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getSecureKeyValuePairs...");
        }
        if (this.delegate != null) {
            this.delegate.getSecureKeyValuePairs(keys, publicAccessName, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getSecureKeyValuePairs' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getSecureKeyValuePairs'.");
        }
    }

    @Override
    public boolean isDeviceModified() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing isDeviceModified...");
        }
        boolean result = false;
        if (this.delegate != null) {
            result = this.delegate.isDeviceModified();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'isDeviceModified' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'isDeviceModified'.");
        }
        return result;
    }

    @Override
    public void setSecureKeyValuePairs(SecureKeyPair[] keyValues, String publicAccessName, ISecurityResultCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing setSecureKeyValuePairs...");
        }
        if (this.delegate != null) {
            this.delegate.setSecureKeyValuePairs(keyValues, publicAccessName, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'setSecureKeyValuePairs' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'setSecureKeyValuePairs'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "deleteSecureKeyValuePairs": {
                String[] keys0 = (String[])this.getJSONParser().fromJson(request.getParameters()[0], String[].class);
                String publicAccessName0 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                SecurityResultCallbackImpl callback0 = new SecurityResultCallbackImpl(request.getAsyncId());
                this.deleteSecureKeyValuePairs(keys0, publicAccessName0, callback0);
                break;
            }
            case "getSecureKeyValuePairs": {
                String[] keys1 = (String[])this.getJSONParser().fromJson(request.getParameters()[0], String[].class);
                String publicAccessName1 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                SecurityResultCallbackImpl callback1 = new SecurityResultCallbackImpl(request.getAsyncId());
                this.getSecureKeyValuePairs(keys1, publicAccessName1, callback1);
                break;
            }
            case "isDeviceModified": {
                boolean response2 = this.isDeviceModified();
                responseJSON = this.getJSONParser().toJson((Object)response2);
                break;
            }
            case "setSecureKeyValuePairs": {
                SecureKeyPair[] keyValues3 = (SecureKeyPair[])this.getJSONParser().fromJson(request.getParameters()[0], SecureKeyPair[].class);
                String publicAccessName3 = (String)this.getJSONParser().fromJson(request.getParameters()[1], String.class);
                SecurityResultCallbackImpl callback3 = new SecurityResultCallbackImpl(request.getAsyncId());
                this.setSecureKeyValuePairs(keyValues3, publicAccessName3, callback3);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "SecurityBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.0.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

