/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseCommunicationBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.INetworkReachability;
import me.adaptive.arp.api.INetworkReachabilityCallback;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.NetworkReachabilityCallbackImpl;

public class NetworkReachabilityBridge
extends BaseCommunicationBridge
implements INetworkReachability,
APIBridge {
    private INetworkReachability delegate;

    public NetworkReachabilityBridge(INetworkReachability delegate) {
        this.delegate = delegate;
    }

    public final INetworkReachability getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(INetworkReachability delegate) {
        this.delegate = delegate;
    }

    @Override
    public void isNetworkReachable(String host, INetworkReachabilityCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing isNetworkReachable...");
        }
        if (this.delegate != null) {
            this.delegate.isNetworkReachable(host, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'isNetworkReachable' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'isNetworkReachable'.");
        }
    }

    @Override
    public void isNetworkServiceReachable(String url, INetworkReachabilityCallback callback) {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing isNetworkServiceReachable...");
        }
        if (this.delegate != null) {
            this.delegate.isNetworkServiceReachable(url, callback);
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'isNetworkServiceReachable' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'isNetworkServiceReachable'.");
        }
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "isNetworkReachable": {
                String host0 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                NetworkReachabilityCallbackImpl callback0 = new NetworkReachabilityCallbackImpl(request.getAsyncId());
                this.isNetworkReachable(host0, callback0);
                break;
            }
            case "isNetworkServiceReachable": {
                String url1 = (String)this.getJSONParser().fromJson(request.getParameters()[0], String.class);
                NetworkReachabilityCallbackImpl callback1 = new NetworkReachabilityCallbackImpl(request.getAsyncId());
                this.isNetworkServiceReachable(url1, callback1);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "NetworkReachabilityBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.0.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

