/*
 * Decompiled with CFR 0.152.
 */
package me.adaptive.arp.api;

import me.adaptive.arp.api.APIBridge;
import me.adaptive.arp.api.APIRequest;
import me.adaptive.arp.api.APIResponse;
import me.adaptive.arp.api.AppRegistryBridge;
import me.adaptive.arp.api.BaseSystemBridge;
import me.adaptive.arp.api.ILoggingLogLevel;
import me.adaptive.arp.api.IOS;
import me.adaptive.arp.api.LoggingBridge;
import me.adaptive.arp.api.OSInfo;

public class OSBridge
extends BaseSystemBridge
implements IOS,
APIBridge {
    private IOS delegate;

    public OSBridge(IOS delegate) {
        this.delegate = delegate;
    }

    public final IOS getDelegate() {
        return this.delegate;
    }

    public final void setDelegate(IOS delegate) {
        this.delegate = delegate;
    }

    @Override
    public OSInfo getOSInfo() {
        long tIn = System.currentTimeMillis();
        LoggingBridge logger = AppRegistryBridge.getInstance().getLoggingBridge();
        if (logger != null) {
            logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executing getOSInfo...");
        }
        OSInfo result = null;
        if (this.delegate != null) {
            result = this.delegate.getOSInfo();
            if (logger != null) {
                logger.log(ILoggingLogLevel.Debug, this.apiGroup.name(), this.getClass().getSimpleName() + " executed 'getOSInfo' in " + (System.currentTimeMillis() - tIn) + "ms.");
            }
        } else if (logger != null) {
            logger.log(ILoggingLogLevel.Error, this.apiGroup.name(), this.getClass().getSimpleName() + " no delegate for 'getOSInfo'.");
        }
        return result;
    }

    @Override
    public APIResponse invoke(APIRequest request) {
        APIResponse response = new APIResponse();
        int responseCode = 200;
        String responseMessage = "OK";
        String responseJSON = "null";
        switch (request.getMethodName()) {
            case "getOSInfo": {
                OSInfo response0 = this.getOSInfo();
                if (response0 == null) break;
                responseJSON = this.getJSONParser().toJson((Object)response0);
                break;
            }
            default: {
                responseCode = 404;
                responseMessage = "OSBridge does not provide the function '" + request.getMethodName() + "' Please check your client-side API version; should be API version >= v2.2.0.";
            }
        }
        response.setResponse(responseJSON);
        response.setStatusCode(responseCode);
        response.setStatusMessage(responseMessage);
        return response;
    }
}

