/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.dependency;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.MavenUtils;
import org.apache.maven.dependency.JarUtil;
import org.apache.maven.dependency.ProjectResolver;
import org.apache.maven.importscrubber.ClassParserWrapper;
import org.apache.maven.importscrubber.IReferenceFoundListener;
import org.apache.maven.importscrubber.TreeMapListener;

public class BytecodeProjectResolver {
    private File base;
    private TreeMapListener treeMapListener;
    private List packageReferences = new LinkedList();
    private List packageExcludes = new LinkedList();
    private File mapFile;
    private List projectReferences;

    public BytecodeProjectResolver() {
        this.treeMapListener = new TreeMapListener();
        this.projectReferences = new LinkedList();
    }

    public void setPackageExcludes(String packageExcludesList) {
        StringTokenizer st = new StringTokenizer(packageExcludesList, ",");
        while (st.hasMoreTokens()) {
            String packageExclude = st.nextToken();
            this.packageExcludes.add(packageExclude);
        }
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void setMapFile(File mapFile) {
        this.mapFile = mapFile;
    }

    public List getPackageReferences() {
        return this.packageReferences;
    }

    public List getProjectReferences() {
        return this.projectReferences;
    }

    public void resolveDependencies() {
        if (this.base.isDirectory()) {
            String[] files = MavenUtils.getFiles((String)this.base.getAbsolutePath(), (String)"*.jar,*.class");
            int i = 0;
            while (i < files.length) {
                String file = files[i];
                if (file.endsWith("jar")) {
                    this.processJAR(file);
                } else {
                    this.processClassReference(file);
                }
                ++i;
            }
        } else {
            this.processJAR(this.base.getAbsolutePath());
        }
        Properties map = new Properties();
        try {
            map.load(new FileInputStream(this.mapFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap projects = new HashMap();
        List packageReferences = this.getPackageReferences();
        Iterator i = packageReferences.iterator();
        while (i.hasNext()) {
            String classReference = (String)i.next();
            Iterator j = ((Hashtable)map).keySet().iterator();
            while (j.hasNext()) {
                String packageKey = (String)j.next();
                if (classReference.indexOf(packageKey) != 0) continue;
                Object o = ((Hashtable)map).get(packageKey);
                projects.put(o, o);
            }
        }
        this.projectReferences.addAll(projects.values());
    }

    public void processJAR(String file) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(new File(file));
            List classEntries = JarUtil.getClassEntries(jarFile);
            this.treeMapListener.getTreeMap().clear();
            Iterator i = classEntries.iterator();
            while (i.hasNext()) {
                JarEntry jarEntry = (JarEntry)i.next();
                InputStream classInputStream = jarFile.getInputStream(jarEntry);
                ClassParserWrapper.parse((InputStream)classInputStream, (IReferenceFoundListener)this.treeMapListener);
            }
            jarFile.close();
            Iterator i2 = this.treeMapListener.getTreeMap().keySet().iterator();
            while (i2.hasNext()) {
                String classReference = (String)i2.next();
                this.processClassReference(classReference);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processClassReference(String classReference) {
        if (classReference.indexOf("$") < 0 && !classReference.startsWith("[")) {
            boolean includePackage = true;
            Iterator j = this.packageExcludes.iterator();
            while (j.hasNext()) {
                String packageExclude = (String)j.next();
                if (!classReference.startsWith(packageExclude)) continue;
                includePackage = false;
                break;
            }
            if (includePackage) {
                this.packageReferences.add(this.treeMapListener.getTreeMap().get(classReference));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ProjectResolver bdr = new ProjectResolver();
        bdr.setBase(new File(args[0]));
        bdr.setPackageExcludes(args[1]);
        bdr.setMapFile(new File(args[2]));
        bdr.resolveDependencies();
        List projectReferences = bdr.getProjectReferences();
        Iterator i = projectReferences.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }
}

