/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LinearShape2D;
import math.utils.EqualUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineArc2D
extends AbstractLine2D
implements SmoothOrientedCurve2D,
Cloneable {
    protected double t0 = 0.0;
    protected double t1 = 1.0;

    public static LineArc2D create(Point2D p1, Point2D p2, double t0, double t1) {
        return new LineArc2D(p1, p2, t0, t1);
    }

    public LineArc2D(Point2D point1, Point2D point2, double t0, double t1) {
        this(point1.x(), point1.y(), point2.x() - point1.x(), point2.y() - point1.y(), t0, t1);
    }

    public LineArc2D(LinearShape2D line, double t0, double t1) {
        super(line);
        this.t0 = t0;
        this.t1 = t1;
    }

    public LineArc2D(LineArc2D line) {
        this(line.x0, line.y0, line.dx, line.dy, line.t0, line.t1);
    }

    public LineArc2D(double x1, double y1, double dx, double dy, double t0, double t1) {
        super(x1, y1, dx, dy);
        this.t0 = t0;
        this.t1 = t1;
    }

    @Override
    public double length() {
        if (this.isBounded()) {
            return this.firstPoint().distance(this.lastPoint());
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getX1() {
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            return this.x0 + this.t0 * this.dx;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getY1() {
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            return this.y0 + this.t0 * this.dy;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getX2() {
        if (this.t1 != Double.POSITIVE_INFINITY) {
            return this.x0 + this.t1 * this.dx;
        }
        return Double.POSITIVE_INFINITY;
    }

    public double getY2() {
        if (this.t1 != Double.POSITIVE_INFINITY) {
            return this.y0 + this.t1 * this.dy;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public LineArc2D parallel(double d) {
        double d2 = d / Math.hypot(this.dx, this.dy);
        return new LineArc2D(this.x0 + this.dy * d2, this.y0 - this.dx * d2, this.dx, this.dy, this.t0, this.t1);
    }

    @Override
    public double t0() {
        return this.t0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return this.t1;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        if (t < this.t0) {
            t = this.t0;
        }
        if (t > this.t1) {
            t = this.t1;
        }
        if (Double.isInfinite(t)) {
            throw new UnboundedShape2DException(this);
        }
        return new Point2D(this.x0 + this.dx * t, this.y0 + this.dy * t);
    }

    @Override
    public Point2D firstPoint() {
        if (!Double.isInfinite(this.t0)) {
            return new Point2D(this.x0 + this.t0 * this.dx, this.y0 + this.t0 * this.dy);
        }
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Point2D lastPoint() {
        if (!Double.isInfinite(this.t1)) {
            return new Point2D(this.x0 + this.t1 * this.dx, this.y0 + this.t1 * this.dy);
        }
        throw new UnboundedShape2DException(this);
    }

    @Override
    public Collection<Point2D> singularPoints() {
        ArrayList<Point2D> list = new ArrayList<Point2D>(2);
        if (this.t0 != Double.NEGATIVE_INFINITY) {
            list.add(this.firstPoint());
        }
        if (this.t1 != Double.POSITIVE_INFINITY) {
            list.add(this.lastPoint());
        }
        return list;
    }

    @Override
    public boolean isSingular(double pos) {
        if (Math.abs(pos - this.t0) < 1.0E-12) {
            return true;
        }
        return Math.abs(pos - this.t1) < 1.0E-12;
    }

    public Collection<? extends LineArc2D> continuousCurves() {
        return LineArc2D.wrapCurve(this);
    }

    @Override
    public LineArc2D reverse() {
        return new LineArc2D(this.x0, this.y0, -this.dx, -this.dy, -this.t1, -this.t0);
    }

    @Override
    public LineArc2D subCurve(double t0, double t1) {
        t0 = Math.max(t0, this.t0());
        t1 = Math.min(t1, this.t1());
        return new LineArc2D(this, t0, t1);
    }

    @Override
    public boolean isBounded() {
        return this.t0 != Double.NEGATIVE_INFINITY && this.t1 != Double.POSITIVE_INFINITY;
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(this.x0 + this.t0 * this.dx, this.x0 + this.t1 * this.dx, this.y0 + this.t0 * this.dy, this.y0 + this.t1 * this.dy);
    }

    @Override
    public boolean contains(Point2D pt) {
        return this.contains(pt.x(), pt.y());
    }

    @Override
    public boolean contains(double xp, double yp) {
        if (!super.supportContains(xp, yp)) {
            return false;
        }
        double t = this.positionOnLine(xp, yp);
        if (t - this.t0 < -1.0E-12) {
            return false;
        }
        return !(t - this.t1 > 1.0E-12);
    }

    public GeneralPath getGeneralPath() {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(this.x0 + this.t0 * this.dx), (float)(this.y0 + this.t0 * this.dy));
        path.lineTo((float)(this.x0 + this.t1 * this.dx), (float)(this.y0 + this.t1 * this.dy));
        return path;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        if (this.t0 == Double.NEGATIVE_INFINITY) {
            return path;
        }
        if (this.t1 == Double.POSITIVE_INFINITY) {
            return path;
        }
        path.lineTo((float)this.getX1(), (float)this.getY1());
        path.lineTo((float)this.getX2(), (float)this.getY2());
        return path;
    }

    @Override
    public LineArc2D transform(AffineTransform2D trans) {
        double[] tab = trans.coefficients();
        double x1 = this.x0 * tab[0] + this.y0 * tab[1] + tab[2];
        double y1 = this.x0 * tab[3] + this.y0 * tab[4] + tab[5];
        return new LineArc2D(x1, y1, this.dx * tab[0] + this.dy * tab[1], this.dx * tab[3] + this.dy * tab[4], this.t0, this.t1);
    }

    public String toString() {
        return new String("LineArc2D(" + this.x0 + "," + this.y0 + "," + this.dx + "," + this.dy + "," + this.t0 + "," + this.t1 + ")");
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineArc2D)) {
            return false;
        }
        LineArc2D that = (LineArc2D)obj;
        if (!LineArc2D.almostEquals(this.x0, that.x0, eps)) {
            return false;
        }
        if (!LineArc2D.almostEquals(this.y0, that.y0, eps)) {
            return false;
        }
        if (!LineArc2D.almostEquals(this.dx, that.dx, eps)) {
            return false;
        }
        if (!LineArc2D.almostEquals(this.dy, that.dy, eps)) {
            return false;
        }
        if (!LineArc2D.almostEquals(this.t0, that.t0, eps)) {
            return false;
        }
        return LineArc2D.almostEquals(this.t1, that.t1, eps);
    }

    private static boolean almostEquals(double d1, double d2, double eps) {
        if (d1 == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
            return true;
        }
        if (d1 == Double.NEGATIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY) {
            return true;
        }
        return Math.abs(d1 - d2) < eps;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineArc2D)) {
            return false;
        }
        LineArc2D that = (LineArc2D)obj;
        if (!EqualUtils.areEqual(this.x0, that.x0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.y0, that.y0)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.dx, that.dx)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.dy, that.dy)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.t0, that.t0)) {
            return false;
        }
        return EqualUtils.areEqual(this.t1, that.t1);
    }

    @Override
    public LineArc2D clone() {
        return new LineArc2D(this.x0, this.y0, this.dx, this.dy, this.t0, this.t1);
    }
}

