/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.extras.DOMConfigurator;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.spi.TriggeringEventEvaluator;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

public final class FilterBasedTriggeringPolicy
implements TriggeringPolicy,
TriggeringEventEvaluator,
UnrecognizedElementHandler {
    private Filter headFilter;
    private Filter tailFilter;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;

    public boolean isTriggeringEvent(LoggingEvent event) {
        if (this.headFilter == null) {
            return false;
        }
        Filter f = this.headFilter;
        while (f != null) {
            switch (f.decide(event)) {
                case -1: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            f = f.next;
        }
        return true;
    }

    public boolean isTriggeringEvent(Appender appender, LoggingEvent event, String file, long fileLength) {
        return this.isTriggeringEvent(event);
    }

    public void addFilter(Filter newFilter) {
        if (this.headFilter == null) {
            this.headFilter = newFilter;
            this.tailFilter = newFilter;
        } else {
            this.tailFilter.next = newFilter;
            this.tailFilter = newFilter;
        }
    }

    public void clearFilters() {
        this.headFilter = null;
        this.tailFilter = null;
    }

    public Filter getFilter() {
        return this.headFilter;
    }

    public void activateOptions() {
        Filter f = this.headFilter;
        while (f != null) {
            f.activateOptions();
            f = f.next;
        }
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        String nodeName = element.getNodeName();
        if ("filter".equals(nodeName)) {
            OptionHandler filter = DOMConfigurator.parseElement(element, props, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = FilterBasedTriggeringPolicy.class$("org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter);
            if (filter instanceof Filter) {
                filter.activateOptions();
                this.addFilter((Filter)filter);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

