/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.virtualbackground;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.effectssdk.tsvb.EffectsSDK;
import com.effectssdk.tsvb.SDKFactory;
import com.effectssdk.tsvb.pipeline.ImagePipeline;
import com.effectssdk.tsvb.pipeline.PipelineMode;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.plugin.video.HMSVideoPluginType;
import live.hms.video.plugin.video.utils.HMSBitmapPlugin;
import live.hms.video.plugin.video.virtualbackground.HmsVirtualBackgroundInterface;
import live.hms.video.plugin.video.virtualbackground.VideoFrameInfoListener;
import live.hms.video.plugin.video.virtualbackground.VideoPluginMode;
import live.hms.video.sdk.HMSPluginResultListener;
import live.hms.video.sdk.HMSSDK;
import live.hms.video.sdk.ProcessTimeVariables;
import live.hms.video.sdk.models.HMSLocalPeer;
import live.hms.video.utils.HMSLogger;
import live.hms.video.virtualbackground.ExtKt;
import live.hms.video.virtualbackground.HMSVirtualBackground;
import live.hms.video.virtualbackground.MainThreadExecutor;
import live.hms.video.virtualbackground.YuvFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 W2\u00020\u0001:\u0001WB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000206H\u0016J*\u00107\u001a\u0002062\u0006\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010:\u001a\u00020\u001bH\u0002J\u0010\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020\u0014H\u0016J\u0010\u0010=\u001a\u0002062\u0006\u0010>\u001a\u00020\u0016H\u0016J\b\u0010?\u001a\u00020\u0016H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020)H\u0002J\b\u0010C\u001a\u00020\u0006H\u0016J\b\u0010D\u001a\u00020EH\u0016J\u0011\u0010F\u001a\u000206H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0011\u0010H\u001a\u000206H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0018\u0010I\u001a\u0002062\u0006\u0010J\u001a\u00020\u00162\u0006\u0010K\u001a\u00020\u0016H\u0002J\b\u0010L\u001a\u000204H\u0016J)\u0010M\u001a\u0002062\u0006\u0010N\u001a\u00020O2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010P\u001a\u0004\u0018\u000104H\u0016\u00a2\u0006\u0002\u0010QJ\u0010\u0010R\u001a\u0002062\u0006\u0010S\u001a\u00020\u0006H\u0016J\u0010\u0010T\u001a\u0002062\u0006\u0010U\u001a\u000200H\u0016J\b\u0010V\u001a\u000206H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010-\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010.R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u0004\u0018\u000102X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006X"}, d2={"Llive/hms/video/virtualbackground/HMSVirtualBackground;", "Llive/hms/video/plugin/video/virtualbackground/HmsVirtualBackgroundInterface;", "hmsSdk", "Llive/hms/video/sdk/HMSSDK;", "(Llive/hms/video/sdk/HMSSDK;)V", "effectsKey", "", "effectsSDKFactory", "Lcom/effectssdk/tsvb/SDKFactory;", "getEffectsSDKFactory", "()Lcom/effectssdk/tsvb/SDKFactory;", "effectsSDKFactory$delegate", "Lkotlin/Lazy;", "enableEffects", "Ljava/util/concurrent/atomic/AtomicBoolean;", "imageAspectRatio", "", "imagePipeline", "Lcom/effectssdk/tsvb/pipeline/ImagePipeline;", "inputFrameBitmap", "Landroid/graphics/Bitmap;", "inputHeight", "", "inputTextureBuffer", "Lorg/webrtc/VideoFrame$TextureBuffer;", "inputTimeQueue", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "", "inputWidth", "name", "obj", "Ljava/lang/Object;", "originalFps", "originalHeight", "originalWidth", "outputListener", "Llive/hms/video/sdk/HMSPluginResultListener;", "pendingBitmap", "pendingBlur", "Ljava/lang/Integer;", "pendingMode", "Llive/hms/video/plugin/video/virtualbackground/VideoPluginMode;", "startTimeQueue", "surfTextureHelper", "Lorg/webrtc/SurfaceTextureHelper;", "timeBeforeProcessing", "Ljava/lang/Long;", "videoFrameInfoListener", "Llive/hms/video/plugin/video/virtualbackground/VideoFrameInfoListener;", "yuvConverter", "Lorg/webrtc/YuvConverter;", "checkSupportedResolution", "", "disableEffects", "", "drawOutputBitmapOnFrame", "newBitmap", "frameTs", "startTime", "enableBackground", "bitmap", "enableBlur", "blurPercentage", "getCurrentBlurPercentage", "getEffectsMode", "Lcom/effectssdk/tsvb/pipeline/PipelineMode;", "videoPluginMode", "getName", "getPluginType", "Llive/hms/video/plugin/video/HMSVideoPluginType;", "init", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initEffectsSDK", "initInputTextureBuffer", "newWidth", "newHeight", "isSupported", "processVideoFrame", "inputVideoFrame", "Lorg/webrtc/VideoFrame;", "skipProcessing", "(Lorg/webrtc/VideoFrame;Llive/hms/video/sdk/HMSPluginResultListener;Ljava/lang/Boolean;)V", "setKey", "key", "setVideoFrameInfoListener", "listener", "stop", "Companion", "virtualBackground_release"})
public final class HMSVirtualBackground
implements HmsVirtualBackgroundInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HMSSDK hmsSdk;
    @Nullable
    private YuvConverter yuvConverter;
    @Nullable
    private VideoFrame.TextureBuffer inputTextureBuffer;
    @Nullable
    private SurfaceTextureHelper surfTextureHelper;
    private int inputWidth;
    @Nullable
    private VideoFrameInfoListener videoFrameInfoListener;
    private int inputHeight;
    private int originalWidth;
    private int originalHeight;
    private int originalFps;
    private float imageAspectRatio;
    @Nullable
    private Bitmap inputFrameBitmap;
    @Nullable
    private String effectsKey;
    @NotNull
    private String name;
    @Nullable
    private HMSPluginResultListener outputListener;
    @NotNull
    private final Lazy effectsSDKFactory$delegate;
    @Nullable
    private Bitmap pendingBitmap;
    @Nullable
    private Integer pendingBlur;
    @NotNull
    private VideoPluginMode pendingMode;
    @Nullable
    private ImagePipeline imagePipeline;
    @NotNull
    private ConcurrentLinkedDeque<Long> startTimeQueue;
    @NotNull
    private ConcurrentLinkedDeque<Long> inputTimeQueue;
    @NotNull
    private final Object obj;
    @NotNull
    private final AtomicBoolean enableEffects;
    @Nullable
    private Long timeBeforeProcessing;
    @NotNull
    public static final String TAG = "HMSVirtualBlurFilter";
    @NotNull
    private static int[] textures = new int[1];
    private static int MIN_API_LEVEL = 21;

    public HMSVirtualBackground(@NotNull HMSSDK hmsSdk) {
        Intrinsics.checkNotNullParameter((Object)hmsSdk, (String)"hmsSdk");
        this.hmsSdk = hmsSdk;
        this.imageAspectRatio = 1.0f;
        this.name = "@100mslive/hms-virtual-background";
        this.effectsSDKFactory$delegate = LazyKt.lazy((Function0)effectsSDKFactory.2.INSTANCE);
        this.pendingMode = VideoPluginMode.NONE;
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        Log.d((String)"LeakTest", (String)"HMSVirtualBG created");
        this.startTimeQueue = new ConcurrentLinkedDeque();
        this.inputTimeQueue = new ConcurrentLinkedDeque();
        this.obj = new Object();
        this.enableEffects = new AtomicBoolean(false);
    }

    private final SDKFactory getEffectsSDKFactory() {
        Lazy lazy = this.effectsSDKFactory$delegate;
        return (SDKFactory)lazy.getValue();
    }

    @Nullable
    public Object init(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.initEffectsSDK($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final PipelineMode getEffectsMode(VideoPluginMode videoPluginMode) {
        PipelineMode pipelineMode;
        switch (WhenMappings.$EnumSwitchMapping$0[videoPluginMode.ordinal()]) {
            case 1: {
                pipelineMode = PipelineMode.REPLACE;
                break;
            }
            case 2: {
                pipelineMode = PipelineMode.NO_EFFECT;
                break;
            }
            case 3: {
                pipelineMode = PipelineMode.BLUR;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pipelineMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object initEffectsSDK(Continuation<? super Unit> $completion) {
        Object object = this.obj;
        synchronized (object) {
            boolean bl = false;
            Unit unit = (Unit)MainThreadExecutor.INSTANCE.executeOnMainThreadBlocking((Function0)new Function0<Unit>(this){
                final /* synthetic */ HMSVirtualBackground this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Unit invoke() {
                    Unit unit;
                    Object object;
                    HMSVirtualBackground hMSVirtualBackground = this.this$0;
                    try {
                        boolean bl = false;
                        Context context = HMSVirtualBackground.access$getHmsSdk$p(hMSVirtualBackground).getApplicationContext();
                        String string = HMSVirtualBackground.access$getEffectsKey$p(hMSVirtualBackground);
                        if (string == null) {
                            string = "";
                        }
                        ExtKt.init(EffectsSDK.INSTANCE, context, string);
                        SDKFactory sDKFactory = HMSVirtualBackground.access$getEffectsSDKFactory(hMSVirtualBackground);
                        Context context2 = HMSVirtualBackground.access$getHmsSdk$p(hMSVirtualBackground).getApplicationContext();
                        PipelineMode pipelineMode = HMSVirtualBackground.access$getEffectsMode(hMSVirtualBackground, HMSVirtualBackground.access$getPendingMode$p(hMSVirtualBackground));
                        Bitmap bitmap = HMSVirtualBackground.access$getPendingBitmap$p(hMSVirtualBackground);
                        Integer n = HMSVirtualBackground.access$getPendingBlur$p(hMSVirtualBackground);
                        object = Result.constructor-impl((Object)ExtKt.createPipeLine(sDKFactory, context2, pipelineMode, n, bitmap));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    Object initEffectsSdkResult = object;
                    if (Result.isSuccess-impl((Object)initEffectsSdkResult)) {
                        HMSVirtualBackground.access$setImagePipeline$p(this.this$0, (ImagePipeline)(Result.isFailure-impl((Object)initEffectsSdkResult) ? null : initEffectsSdkResult));
                        ImagePipeline imagePipeline = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                        if (imagePipeline != null) {
                            imagePipeline.setOnFrameAvailableListener(arg_0 -> initEffectsSDK.2.1.invoke$lambda$1(this.this$0, arg_0));
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                    } else {
                        throw ExtKt.exceptionToHmsException("Sdk init failed", Result.exceptionOrNull-impl((Object)initEffectsSdkResult));
                    }
                    return unit;
                }

                private static final void invoke$lambda$1(HMSVirtualBackground this$0, Bitmap processedBitmap) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)processedBitmap, (String)"processedBitmap");
                    HMSLogger.d((String)"HMSVirtualBlurFilter", (String)"Effects SDK Processing done .. ");
                    long l = System.nanoTime();
                    HMSPluginResultListener hMSPluginResultListener = HMSVirtualBackground.access$getOutputListener$p(this$0);
                    E e = HMSVirtualBackground.access$getStartTimeQueue$p(this$0).remove();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"startTimeQueue.remove()");
                    HMSVirtualBackground.access$drawOutputBitmapOnFrame(this$0, processedBitmap, l, hMSPluginResultListener, ((Number)e).longValue());
                }
            });
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public HMSVideoPluginType getPluginType() {
        return this.enableEffects.get() ? HMSVideoPluginType.TRANSFORM : HMSVideoPluginType.ANALYZE;
    }

    public int getCurrentBlurPercentage() {
        Float blurPower;
        ImagePipeline imagePipeline = this.imagePipeline;
        Float f = blurPower = imagePipeline != null ? Float.valueOf(imagePipeline.getBlurPower()) : null;
        if (blurPower != null) {
            return (int)(blurPower.floatValue() * (float)100);
        }
        return 75;
    }

    public void enableBlur(int blurPercentage) {
        this.enableEffects.getAndSet(true);
        MainThreadExecutor.INSTANCE.executeOnMainThreadBlocking((Function0)new Function0<Unit>(this, blurPercentage){
            final /* synthetic */ HMSVirtualBackground this$0;
            final /* synthetic */ int $blurPercentage;
            {
                this.this$0 = $receiver;
                this.$blurPercentage = $blurPercentage;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                ImagePipeline imagePipeline = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                if (imagePipeline != null) {
                    imagePipeline.setMode(HMSVirtualBackground.access$getEffectsMode(this.this$0, VideoPluginMode.BLUR_BACKGROUND));
                }
                ImagePipeline imagePipeline2 = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                if (imagePipeline2 != null) {
                    imagePipeline2.setBlurPower((float)this.$blurPercentage / 100.0f);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
        this.pendingMode = VideoPluginMode.BLUR_BACKGROUND;
        this.pendingBlur = blurPercentage;
    }

    public void enableBackground(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.enableEffects.getAndSet(true);
        MainThreadExecutor.INSTANCE.executeOnMainThreadBlocking((Function0)new Function0<Unit>(this, bitmap){
            final /* synthetic */ HMSVirtualBackground this$0;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$bitmap = $bitmap;
                super(0);
            }

            @Nullable
            public final Unit invoke() {
                Unit unit;
                ImagePipeline imagePipeline = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                if (imagePipeline != null) {
                    imagePipeline.setMode(HMSVirtualBackground.access$getEffectsMode(this.this$0, VideoPluginMode.REPLACE_BACKGROUND));
                }
                ImagePipeline imagePipeline2 = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                if (imagePipeline2 != null) {
                    imagePipeline2.setBackground(this.$bitmap);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
        });
        this.pendingMode = VideoPluginMode.REPLACE_BACKGROUND;
        this.pendingBitmap = bitmap;
    }

    public void disableEffects() {
        this.enableEffects.getAndSet(false);
    }

    public void setVideoFrameInfoListener(@NotNull VideoFrameInfoListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.videoFrameInfoListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processVideoFrame(@NotNull VideoFrame inputVideoFrame, @Nullable HMSPluginResultListener outputListener, @Nullable Boolean skipProcessing) {
        Intrinsics.checkNotNullParameter((Object)inputVideoFrame, (String)"inputVideoFrame");
        VideoFrameInfoListener videoFrameInfoListener = this.videoFrameInfoListener;
        if (videoFrameInfoListener != null) {
            videoFrameInfoListener.onFrame(inputVideoFrame.getRotatedWidth(), inputVideoFrame.getRotatedHeight(), inputVideoFrame.getRotation());
        }
        if (!this.enableEffects.get()) {
            return;
        }
        HMSLogger.INSTANCE.v(TAG, "~~ New input frame received ~~");
        Object object = this.obj;
        synchronized (object) {
            Unit unit;
            block13: {
                block12: {
                    boolean bl = false;
                    this.outputListener = outputListener;
                    long startTime = System.currentTimeMillis();
                    this.startTimeQueue.add(startTime);
                    this.inputTimeQueue.add(inputVideoFrame.getTimestampNs());
                    if (this.surfTextureHelper == null) {
                        HMSLocalPeer hMSLocalPeer = this.hmsSdk.getLocalPeer();
                        this.surfTextureHelper = hMSLocalPeer != null && (hMSLocalPeer = hMSLocalPeer.getVideoTrack()) != null ? hMSLocalPeer.getTextureHelper() : null;
                    }
                    YuvFrame inputYuvFrame = new YuvFrame(inputVideoFrame, 0, inputVideoFrame.getTimestampNs());
                    this.inputFrameBitmap = inputYuvFrame.getBitmap();
                    long timeAfterBitmapConvertion = System.currentTimeMillis();
                    HMSLogger.INSTANCE.i(TAG, "~~ Time taken to convert input to bitmap :: " + (timeAfterBitmapConvertion - startTime) + " ms");
                    if (this.inputFrameBitmap == null) break block12;
                    Bitmap bitmap = this.inputFrameBitmap;
                    if ((bitmap != null ? Integer.valueOf(bitmap.getWidth()) : null) == null) break block12;
                    Bitmap bitmap2 = this.inputFrameBitmap;
                    if ((bitmap2 != null ? Integer.valueOf(bitmap2.getHeight()) : null) != null) break block13;
                }
                HMSLogger.e((String)TAG, (String)"Failed to convert input frame to bitmap");
                HMSPluginResultListener hMSPluginResultListener = outputListener;
                if (hMSPluginResultListener != null) {
                    hMSPluginResultListener.onOutputResult(inputVideoFrame);
                }
                return;
            }
            if (this.yuvConverter == null) {
                this.yuvConverter = new YuvConverter();
            }
            Bitmap bitmap = this.inputFrameBitmap;
            Intrinsics.checkNotNull((Object)bitmap);
            int n = bitmap.getWidth();
            Bitmap bitmap3 = this.inputFrameBitmap;
            Intrinsics.checkNotNull((Object)bitmap3);
            this.initInputTextureBuffer(n, bitmap3.getHeight());
            Bitmap bitmap4 = this.inputFrameBitmap;
            if (bitmap4 != null) {
                Bitmap it = bitmap4;
                boolean bl = false;
                HMSLogger.d((String)TAG, (String)"sending input bitmap for processing..");
                this.timeBeforeProcessing = System.currentTimeMillis();
                unit = (Unit)MainThreadExecutor.INSTANCE.executeOnMainThreadBlocking((Function0)new Function0<Unit>(this, it){
                    final /* synthetic */ HMSVirtualBackground this$0;
                    final /* synthetic */ Bitmap $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Unit invoke() {
                        Unit unit;
                        ImagePipeline imagePipeline = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                        if (imagePipeline != null) {
                            imagePipeline.process(this.$it);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        return unit;
                    }
                });
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.originalWidth = 0;
        this.originalHeight = 0;
        this.originalFps = 0;
        Object object = this.obj;
        synchronized (object) {
            boolean bl = false;
            MainThreadExecutor.INSTANCE.executeOnMainThreadBlocking((Function0)new Function0<Unit>(this){
                final /* synthetic */ HMSVirtualBackground this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    ImagePipeline imagePipeline = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                    if (imagePipeline != null) {
                        imagePipeline.setMode(PipelineMode.NO_EFFECT);
                    }
                    ImagePipeline imagePipeline2 = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                    if (imagePipeline2 != null) {
                        imagePipeline2.setMode(PipelineMode.NO_EFFECT);
                    }
                    ImagePipeline imagePipeline3 = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                    if (imagePipeline3 != null) {
                        imagePipeline3.setOnFrameAvailableListener(null);
                    }
                    ImagePipeline imagePipeline4 = HMSVirtualBackground.access$getImagePipeline$p(this.this$0);
                    if (imagePipeline4 != null) {
                        imagePipeline4.release();
                    }
                    HMSVirtualBackground.access$setImagePipeline$p(this.this$0, null);
                }
            });
            this.pendingBlur = 75;
            YuvConverter yuvConverter = this.yuvConverter;
            if (yuvConverter != null) {
                yuvConverter.release();
            }
            Bitmap bitmap = this.inputFrameBitmap;
            boolean bl2 = bitmap != null ? !bitmap.isRecycled() : false;
            if (bl2) {
                Bitmap bitmap2 = this.inputFrameBitmap;
                if (bitmap2 != null) {
                    bitmap2.recycle();
                }
            }
            GLES20.glDeleteTextures((int)1, (int[])HMSBitmapPlugin.Companion.getTextures(), (int)0);
            Bitmap bitmap3 = this.pendingBitmap;
            if (bitmap3 != null) {
                bitmap3.recycle();
            }
            this.pendingBitmap = null;
            int n = Log.d((String)"LeakTest", (String)"stop plugin called..");
        }
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isSupported() {
        return Build.VERSION.SDK_INT >= MIN_API_LEVEL;
    }

    private final boolean checkSupportedResolution() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void initInputTextureBuffer(int newWidth, int newHeight) {
        if (this.inputWidth != newWidth || this.inputHeight != newHeight) {
            void $this$initInputTextureBuffer_u24lambda_u244;
            Matrix matrix;
            this.inputWidth = newWidth;
            this.inputHeight = newHeight;
            this.imageAspectRatio = (float)this.inputWidth / (float)this.inputHeight;
            VideoFrame.TextureBuffer textureBuffer = this.inputTextureBuffer;
            if (textureBuffer != null) {
                textureBuffer.release();
            }
            Matrix matrix2 = matrix = new Matrix();
            int n = textures[0];
            VideoFrame.TextureBuffer.Type type = VideoFrame.TextureBuffer.Type.RGB;
            int n2 = this.inputHeight;
            int n3 = this.inputWidth;
            HMSVirtualBackground hMSVirtualBackground = this;
            boolean bl = false;
            $this$initInputTextureBuffer_u24lambda_u244.postScale(-1.0f, 1.0f);
            Unit unit = Unit.INSTANCE;
            SurfaceTextureHelper surfaceTextureHelper = this.surfTextureHelper;
            Intrinsics.checkNotNull((Object)surfaceTextureHelper);
            Runnable runnable = null;
            YuvConverter yuvConverter = this.yuvConverter;
            Handler handler = surfaceTextureHelper.getHandler();
            Matrix matrix3 = matrix;
            int n4 = n;
            VideoFrame.TextureBuffer.Type type2 = type;
            int n5 = n2;
            int n6 = n3;
            hMSVirtualBackground.inputTextureBuffer = (VideoFrame.TextureBuffer)new TextureBufferImpl(n6, n5, type2, n4, matrix3, handler, yuvConverter, runnable);
        }
    }

    private final void drawOutputBitmapOnFrame(Bitmap newBitmap, long frameTs, HMSPluginResultListener outputListener, long startTime) {
        block1: {
            SurfaceTextureHelper surfaceTextureHelper;
            if (newBitmap == null || this.surfTextureHelper == null) break block1;
            SurfaceTextureHelper surfaceTextureHelper2 = this.surfTextureHelper;
            Intrinsics.checkNotNull((Object)surfaceTextureHelper2);
            if (surfaceTextureHelper2.getHandler() != null && (surfaceTextureHelper = this.surfTextureHelper) != null && (surfaceTextureHelper = surfaceTextureHelper.getHandler()) != null) {
                surfaceTextureHelper.post(() -> HMSVirtualBackground.drawOutputBitmapOnFrame$lambda$5(newBitmap, this, outputListener, frameTs, startTime));
            }
        }
    }

    public void setKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HmsVirtualBackgroundInterface.DefaultImpls.setKey((HmsVirtualBackgroundInterface)this, (String)key);
        this.effectsKey = key;
    }

    private static final void drawOutputBitmapOnFrame$lambda$5(Bitmap $newBitmap, HMSVirtualBackground this$0, HMSPluginResultListener $outputListener, long $frameTs, long $startTime) {
        block4: {
            VideoFrame.I420Buffer i420Buf;
            Intrinsics.checkNotNullParameter((Object)$newBitmap, (String)"$newBitmap");
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9728);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9728);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)$newBitmap, (int)0);
            YuvConverter yuvConverter = this$0.yuvConverter;
            VideoFrame.I420Buffer i420Buffer = i420Buf = yuvConverter != null ? yuvConverter.convert(this$0.inputTextureBuffer) : null;
            if (i420Buf == null) {
                HMSLogger.e((String)TAG, (String)"Failed to convert bitmap to I420 buffer");
                HMSPluginResultListener hMSPluginResultListener = $outputListener;
                if (hMSPluginResultListener != null) {
                    hMSPluginResultListener.onOutputResult(null);
                }
            } else {
                HMSPluginResultListener hMSPluginResultListener = $outputListener;
                if (hMSPluginResultListener != null) {
                    hMSPluginResultListener.onOutputResult(new VideoFrame((VideoFrame.Buffer)i420Buf, 180, $frameTs));
                }
            }
            ProcessTimeVariables processTime = ProcessTimeVariables.INSTANCE;
            processTime.setTimeTakenWithoutML(System.currentTimeMillis() - $startTime);
            HMSLogger.INSTANCE.v(TAG, "~~ Effects SDK Processing took :: " + processTime.getTimeTakenWithoutML() + " ms to finish");
            HMSPluginResultListener hMSPluginResultListener = $outputListener;
            if (hMSPluginResultListener == null) break block4;
            hMSPluginResultListener.onTimeTaken(processTime);
        }
    }

    public static final /* synthetic */ Object access$initEffectsSDK(HMSVirtualBackground $this, Continuation $completion) {
        return $this.initEffectsSDK((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ ImagePipeline access$getImagePipeline$p(HMSVirtualBackground $this) {
        return $this.imagePipeline;
    }

    public static final /* synthetic */ PipelineMode access$getEffectsMode(HMSVirtualBackground $this, VideoPluginMode videoPluginMode) {
        return $this.getEffectsMode(videoPluginMode);
    }

    public static final /* synthetic */ void access$setImagePipeline$p(HMSVirtualBackground $this, ImagePipeline imagePipeline) {
        $this.imagePipeline = imagePipeline;
    }

    public static final /* synthetic */ HMSSDK access$getHmsSdk$p(HMSVirtualBackground $this) {
        return $this.hmsSdk;
    }

    public static final /* synthetic */ String access$getEffectsKey$p(HMSVirtualBackground $this) {
        return $this.effectsKey;
    }

    public static final /* synthetic */ SDKFactory access$getEffectsSDKFactory(HMSVirtualBackground $this) {
        return $this.getEffectsSDKFactory();
    }

    public static final /* synthetic */ VideoPluginMode access$getPendingMode$p(HMSVirtualBackground $this) {
        return $this.pendingMode;
    }

    public static final /* synthetic */ Bitmap access$getPendingBitmap$p(HMSVirtualBackground $this) {
        return $this.pendingBitmap;
    }

    public static final /* synthetic */ Integer access$getPendingBlur$p(HMSVirtualBackground $this) {
        return $this.pendingBlur;
    }

    public static final /* synthetic */ void access$drawOutputBitmapOnFrame(HMSVirtualBackground $this, Bitmap newBitmap, long frameTs, HMSPluginResultListener outputListener, long startTime) {
        $this.drawOutputBitmapOnFrame(newBitmap, frameTs, outputListener, startTime);
    }

    public static final /* synthetic */ HMSPluginResultListener access$getOutputListener$p(HMSVirtualBackground $this) {
        return $this.outputListener;
    }

    public static final /* synthetic */ ConcurrentLinkedDeque access$getStartTimeQueue$p(HMSVirtualBackground $this) {
        return $this.startTimeQueue;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoPluginMode.values().length];
            try {
                nArray[VideoPluginMode.REPLACE_BACKGROUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoPluginMode.NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoPluginMode.BLUR_BACKGROUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Llive/hms/video/virtualbackground/HMSVirtualBackground$Companion;", "", "()V", "MIN_API_LEVEL", "", "getMIN_API_LEVEL", "()I", "setMIN_API_LEVEL", "(I)V", "TAG", "", "textures", "", "getTextures", "()[I", "setTextures", "([I)V", "virtualBackground_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final int[] getTextures() {
            return textures;
        }

        public final void setTextures(@NotNull int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
            textures = nArray;
        }

        public final int getMIN_API_LEVEL() {
            return MIN_API_LEVEL;
        }

        public final void setMIN_API_LEVEL(int n) {
            MIN_API_LEVEL = n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

