/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.events.AgentType;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.sdk.SignatureChecker;
import live.hms.video.sdk.models.FrameworkInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001d\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\t0\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0010\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\fR\u001b\u0010\u0014\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0015\u0010\fR\u001b\u0010\u0017\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0018\u0010\fR\u001b\u0010\u001a\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0013\u001a\u0004\b\u001b\u0010\f\u00a8\u0006'"}, d2={"Llive/hms/video/utils/HMSAgentOs;", "", "frameworkInfo", "Llive/hms/video/sdk/models/FrameworkInfo;", "signatureChecker", "Llive/hms/video/sdk/SignatureChecker;", "<init>", "(Llive/hms/video/sdk/models/FrameworkInfo;Llive/hms/video/sdk/SignatureChecker;)V", "TAG", "", "USER_AGENT_V2_NAME", "getUSER_AGENT_V2_NAME", "()Ljava/lang/String;", "getUniqueEventId", "event", "Llive/hms/video/events/AnalyticsEvent;", "userAgentUrlEncoded", "getUserAgentUrlEncoded", "userAgentUrlEncoded$delegate", "Lkotlin/Lazy;", "userAgent", "getUserAgent", "userAgent$delegate", "userAgentV2", "getUserAgentV2", "userAgentV2$delegate", "userAgentV2Encoded", "getUserAgentV2Encoded", "userAgentV2Encoded$delegate", "getUrlEncodedAgent", "kotlin.jvm.PlatformType", "agent", "(Ljava/lang/String;)Ljava/lang/String;", "getDeviceId", "context", "Landroid/content/Context;", "bytesToHex", "hash", "", "lib_release"})
public final class HMSAgentOs {
    @NotNull
    private final FrameworkInfo frameworkInfo;
    @NotNull
    private final String TAG;
    @NotNull
    private final String USER_AGENT_V2_NAME;
    @NotNull
    private final Lazy userAgentUrlEncoded$delegate;
    @NotNull
    private final Lazy userAgent$delegate;
    @NotNull
    private final Lazy userAgentV2$delegate;
    @NotNull
    private final Lazy userAgentV2Encoded$delegate;

    public HMSAgentOs(@NotNull FrameworkInfo frameworkInfo, @NotNull SignatureChecker signatureChecker) {
        Intrinsics.checkNotNullParameter((Object)frameworkInfo, (String)"frameworkInfo");
        Intrinsics.checkNotNullParameter((Object)signatureChecker, (String)"signatureChecker");
        this.frameworkInfo = frameworkInfo;
        this.TAG = "HMSAgentOs";
        this.USER_AGENT_V2_NAME = "user_agent_v2";
        this.userAgentUrlEncoded$delegate = LazyKt.lazy(() -> HMSAgentOs.userAgentUrlEncoded_delegate$lambda$0(this));
        this.userAgent$delegate = LazyKt.lazy(() -> HMSAgentOs.userAgent_delegate$lambda$1(this));
        this.userAgentV2$delegate = LazyKt.lazy(() -> HMSAgentOs.userAgentV2_delegate$lambda$2(signatureChecker, this));
        this.userAgentV2Encoded$delegate = LazyKt.lazy(() -> HMSAgentOs.userAgentV2Encoded_delegate$lambda$3(this));
    }

    @NotNull
    public final String getUSER_AGENT_V2_NAME() {
        return this.USER_AGENT_V2_NAME;
    }

    @NotNull
    public final String getUniqueEventId(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return String.valueOf(Math.abs((event.getTimestamp() + event.getName()).hashCode()));
    }

    @NotNull
    public final String getUserAgentUrlEncoded() {
        Lazy lazy = this.userAgentUrlEncoded$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getUserAgent() {
        Lazy lazy = this.userAgent$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserAgentV2() {
        Lazy lazy = this.userAgentV2$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserAgentV2Encoded() {
        Lazy lazy = this.userAgentV2Encoded$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    private final String getUrlEncodedAgent(String agent) {
        String string;
        try {
            string = URLEncoder.encode(agent, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            string = StringsKt.replace$default((String)agent, (String)" ", (String)"_", (boolean)false, (int)4, null);
        }
        return string;
    }

    @SuppressLint(value={"HardwareIds"})
    @NotNull
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        String deviceId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").toString();
        byte[] byArray = digest.digest(StringsKt.encodeToByteArray((String)deviceId));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        byte[] hashedDeviceId = byArray;
        return this.bytesToHex(hashedDeviceId);
    }

    private final String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte by : hash) {
            String hex;
            Intrinsics.checkNotNullExpressionValue((Object)Integer.toHexString(0xFF & by), (String)"toHexString(...)");
            if (hex.length() == 1) {
                hexString.append(0);
            }
            hexString.append(hex);
        }
        String string = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String userAgentUrlEncoded_delegate$lambda$0(HMSAgentOs this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.USER_AGENT_V2_NAME + '=' + this$0.getUserAgentV2Encoded();
    }

    private static final String userAgent_delegate$lambda$1(HMSAgentOs this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getUserAgentV2();
    }

    private static final String userAgentV2_delegate$lambda$2(SignatureChecker $signatureChecker, HMSAgentOs this$0) {
        Intrinsics.checkNotNullParameter((Object)$signatureChecker, (String)"$signatureChecker");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int osVersion = Build.VERSION.SDK_INT;
        String sdkVersion = "2.9.80";
        String string = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
        String buildModel = StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
        String env = $signatureChecker.isReleaseSigned() ? "prod" : "debug";
        return "os:android,os_version:" + osVersion + ",sdk:android,sdk_version:" + sdkVersion + ",device_model:" + buildModel + ",env:" + env + ",is_prebuilt:" + this$0.frameworkInfo.isPrebuilt() + (this$0.frameworkInfo.getFramework() != AgentType.ANDROID_NATIVE ? ",framework:" + this$0.frameworkInfo.getFramework().getServerName() + ",framework_version:" + this$0.frameworkInfo.getFrameworkVersion() + ",framework_sdk_version:" + this$0.frameworkInfo.getFrameworkSdkVersion() : "");
    }

    private static final String userAgentV2Encoded_delegate$lambda$3(HMSAgentOs this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getUrlEncodedAgent(this$0.getUserAgentV2());
    }
}

