/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.tracks;

import hms.webrtc.AudioTrack;
import hms.webrtc.MediaStreamTrack;
import hms.webrtc.RtpParameters;
import hms.webrtc.RtpTransceiver;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import live.hms.video.error.ErrorFactory;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.media.streams.HMSLocalStream;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.media.tracks.HMSAudioTrack;
import live.hms.video.media.tracks.HMSLocalTrack;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.signal.ISignal;
import live.hms.video.utils.HMSCoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B)\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010-J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u0010\"\u001a\u000200H\u0016J\b\u00101\u001a\u00020\nH\u0016J\u0006\u00102\u001a\u00020\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R$\u0010&\u001a\u00020%2\u0006\u0010\"\u001a\u00020%@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*\u00a8\u00063"}, d2={"Llive/hms/video/media/tracks/HMSLocalAudioTrack;", "Llive/hms/video/media/tracks/HMSAudioTrack;", "Llive/hms/video/media/tracks/HMSLocalTrack;", "stream", "Llive/hms/video/media/streams/HMSLocalStream;", "nativeTrack", "Lhms/webrtc/AudioTrack;", "settings", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "source", "", "<init>", "(Llive/hms/video/media/streams/HMSLocalStream;Lhms/webrtc/AudioTrack;Llive/hms/video/media/settings/HMSAudioTrackSettings;Ljava/lang/String;)V", "getStream$lib_release", "()Llive/hms/video/media/streams/HMSLocalStream;", "signal", "Llive/hms/video/signal/ISignal;", "getSignal$lib_release", "()Llive/hms/video/signal/ISignal;", "setSignal$lib_release", "(Llive/hms/video/signal/ISignal;)V", "transceiver", "Lhms/webrtc/RtpTransceiver;", "getTransceiver$lib_release", "()Lhms/webrtc/RtpTransceiver;", "setTransceiver$lib_release", "(Lhms/webrtc/RtpTransceiver;)V", "sendLocalUpdate", "Lkotlin/Function1;", "", "getSendLocalUpdate$lib_release", "()Lkotlin/jvm/functions/Function1;", "setSendLocalUpdate$lib_release", "(Lkotlin/jvm/functions/Function1;)V", "value", "getSettings", "()Llive/hms/video/media/settings/HMSAudioTrackSettings;", "", "volume", "getVolume", "()D", "setVolume", "(D)V", "setSettings", "newSettings", "(Llive/hms/video/media/settings/HMSAudioTrackSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setDescription", "setMute", "", "toString", "setIsDispose", "lib_release"})
public final class HMSLocalAudioTrack
extends HMSAudioTrack
implements HMSLocalTrack {
    @NotNull
    private final HMSLocalStream stream;
    @Nullable
    private ISignal signal;
    @Nullable
    private RtpTransceiver transceiver;
    @Nullable
    private Function1<? super HMSLocalTrack, Unit> sendLocalUpdate;
    @NotNull
    private HMSAudioTrackSettings settings;
    private double volume;

    public HMSLocalAudioTrack(@NotNull HMSLocalStream stream, @NotNull AudioTrack nativeTrack, @NotNull HMSAudioTrackSettings settings, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)nativeTrack, (String)"nativeTrack");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super((HMSMediaStream)stream, nativeTrack, source);
        this.stream = stream;
        this.settings = settings;
        this.getStream$lib_release().getTracks().add(this);
        nativeTrack.setVolume(settings.getVolume());
        if (settings.getInitialState() == HMSTrackSettings.InitState.MUTED) {
            this.setMute(true);
        }
        this.volume = settings.getVolume();
    }

    @Override
    @NotNull
    public HMSLocalStream getStream$lib_release() {
        return this.stream;
    }

    @Nullable
    public final ISignal getSignal$lib_release() {
        return this.signal;
    }

    public final void setSignal$lib_release(@Nullable ISignal iSignal) {
        this.signal = iSignal;
    }

    @Nullable
    public final RtpTransceiver getTransceiver$lib_release() {
        return this.transceiver;
    }

    public final void setTransceiver$lib_release(@Nullable RtpTransceiver rtpTransceiver) {
        this.transceiver = rtpTransceiver;
    }

    @Nullable
    public final Function1<HMSLocalTrack, Unit> getSendLocalUpdate$lib_release() {
        return this.sendLocalUpdate;
    }

    public final void setSendLocalUpdate$lib_release(@Nullable Function1<? super HMSLocalTrack, Unit> function1) {
        this.sendLocalUpdate = function1;
    }

    @NotNull
    public final HMSAudioTrackSettings getSettings() {
        return this.settings;
    }

    public final double getVolume() {
        return this.volume;
    }

    public final void setVolume(double value) {
        if (!this.isDisposed$lib_release()) {
            MediaStreamTrack mediaStreamTrack = this.getNativeTrack$lib_release();
            Intrinsics.checkNotNull((Object)mediaStreamTrack, (String)"null cannot be cast to non-null type hms.webrtc.AudioTrack");
            ((AudioTrack)mediaStreamTrack).setVolume(value);
        }
        this.volume = value;
    }

    @Nullable
    public final Object setSettings(@NotNull HMSAudioTrackSettings newSettings, @NotNull Continuation<? super Unit> $completion) {
        if (this.settings.getCodec() != newSettings.getCodec()) {
            throw ErrorFactory.TracksErrors.CodecChangeNotPermitted$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "Cannot change from " + (Object)((Object)this.settings.getCodec()) + " to " + (Object)((Object)newSettings.getCodec()) + " for " + this, null, null, 12, null);
        }
        if (this.transceiver != null && newSettings.getMaxBitrate() != this.settings.getMaxBitrate()) {
            RtpParameters.Encoding audioEncoding = new RtpParameters.Encoding(null, true, null);
            audioEncoding.bitratePriority = 2.0;
            audioEncoding.maxBitrateBps = Boxing.boxInt((int)(newSettings.getMaxBitrate() * 1000));
            RtpTransceiver rtpTransceiver = this.transceiver;
            Intrinsics.checkNotNull((Object)rtpTransceiver);
            RtpParameters params = rtpTransceiver.getSender().getParameters();
            params.encodings.clear();
            params.encodings.add(audioEncoding);
            RtpTransceiver rtpTransceiver2 = this.transceiver;
            Intrinsics.checkNotNull((Object)rtpTransceiver2);
            rtpTransceiver2.getSender().setParameters(params);
        }
        this.setVolume(newSettings.getVolume());
        this.settings = newSettings;
        return Unit.INSTANCE;
    }

    @Override
    public void setDescription(@NotNull String value) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.setDescription$lib_release(value);
            ISignal iSignal = this.signal;
            if (iSignal == null) break block0;
            iSignal.trackUpdate(CollectionsKt.listOf((Object)HMSNotifications.Track.Companion.from(this)));
        }
    }

    @Override
    public void setMute(boolean value) {
        if (this.isMute() == value) {
            return;
        }
        this.setMute$lib_release(value);
        BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ HMSLocalAudioTrack this$0;
            final /* synthetic */ boolean $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.setEnabled$lib_release(this.$value == false, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = this.this$0.getSignal$lib_release();
                        if (v1 != null) {
                            v1.trackUpdate(CollectionsKt.listOf((Object)HMSNotifications.Track.Companion.from(this.this$0)));
                        }
                        v2 = this.this$0.getSendLocalUpdate$lib_release();
                        if (v2 != null) {
                            v2.invoke((Object)this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public String toString() {
        return "HMSLocalAudioTrack{trackId=" + this.getTrackId() + ", isEnabled=" + this.isEnabled$lib_release() + ", settings=" + this.settings + '}';
    }

    public final void setIsDispose() {
        this.setDisposed$lib_release(true);
    }
}

