/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.database;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import live.hms.video.database.EventsDatabase;
import live.hms.video.database.dao.AnalyticsEventsDao;
import live.hms.video.database.dao.AnalyticsEventsDao_Impl;

public final class EventsDatabase_Impl
extends EventsDatabase {
    private volatile AnalyticsEventsDao _analyticsEventsDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(4){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `analytics_table` (`timestamp` INTEGER NOT NULL, `eventId` TEXT NOT NULL, `payload` TEXT NOT NULL, `eventName` TEXT NOT NULL, `token` TEXT NOT NULL, `isQa` INTEGER NOT NULL, `peerId` TEXT, `role` TEXT, `joinedAt` INTEGER, `leftAt` INTEGER, `roomName` TEXT, `sessionStartedAt` INTEGER, `userData` TEXT, `userName` TEXT, `templateId` TEXT, `sessionId` TEXT, `websocketUrl` TEXT, PRIMARY KEY(`eventId`))");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '356e4a21530b2975a5e43ebcfbd41316')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `analytics_table`");
                List _callbacks = EventsDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = EventsDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                EventsDatabase_Impl.this.mDatabase = db;
                EventsDatabase_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = EventsDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsAnalyticsTable = new HashMap<String, TableInfo.Column>(17);
                _columnsAnalyticsTable.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, 1));
                _columnsAnalyticsTable.put("eventId", new TableInfo.Column("eventId", "TEXT", true, 1, null, 1));
                _columnsAnalyticsTable.put("payload", new TableInfo.Column("payload", "TEXT", true, 0, null, 1));
                _columnsAnalyticsTable.put("eventName", new TableInfo.Column("eventName", "TEXT", true, 0, null, 1));
                _columnsAnalyticsTable.put("token", new TableInfo.Column("token", "TEXT", true, 0, null, 1));
                _columnsAnalyticsTable.put("isQa", new TableInfo.Column("isQa", "INTEGER", true, 0, null, 1));
                _columnsAnalyticsTable.put("peerId", new TableInfo.Column("peerId", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("role", new TableInfo.Column("role", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("joinedAt", new TableInfo.Column("joinedAt", "INTEGER", false, 0, null, 1));
                _columnsAnalyticsTable.put("leftAt", new TableInfo.Column("leftAt", "INTEGER", false, 0, null, 1));
                _columnsAnalyticsTable.put("roomName", new TableInfo.Column("roomName", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("sessionStartedAt", new TableInfo.Column("sessionStartedAt", "INTEGER", false, 0, null, 1));
                _columnsAnalyticsTable.put("userData", new TableInfo.Column("userData", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("userName", new TableInfo.Column("userName", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("templateId", new TableInfo.Column("templateId", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("sessionId", new TableInfo.Column("sessionId", "TEXT", false, 0, null, 1));
                _columnsAnalyticsTable.put("websocketUrl", new TableInfo.Column("websocketUrl", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysAnalyticsTable = new HashSet(0);
                HashSet _indicesAnalyticsTable = new HashSet(0);
                TableInfo _infoAnalyticsTable = new TableInfo("analytics_table", _columnsAnalyticsTable, _foreignKeysAnalyticsTable, _indicesAnalyticsTable);
                TableInfo _existingAnalyticsTable = TableInfo.read((SupportSQLiteDatabase)db, (String)"analytics_table");
                if (!_infoAnalyticsTable.equals((Object)_existingAnalyticsTable)) {
                    return new RoomOpenHelper.ValidationResult(false, "analytics_table(live.hms.video.database.entity.AnalyticsEntityModel).\n Expected:\n" + _infoAnalyticsTable + "\n Found:\n" + _existingAnalyticsTable);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "356e4a21530b2975a5e43ebcfbd41316", "3babbcf080a75b94217adaa8a75688ff");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"analytics_table"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `analytics_table`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(AnalyticsEventsDao.class, AnalyticsEventsDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticsEventsDao logDao() {
        if (this._analyticsEventsDao != null) {
            return this._analyticsEventsDao;
        }
        EventsDatabase_Impl eventsDatabase_Impl = this;
        synchronized (eventsDatabase_Impl) {
            if (this._analyticsEventsDao == null) {
                this._analyticsEventsDao = new AnalyticsEventsDao_Impl(this);
            }
            return this._analyticsEventsDao;
        }
    }
}

