/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera.utils;

import android.media.Image;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\tH\u0002J \u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\tH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002R\u0017\u0010\b\u001a\u00020\t\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer;", "", "image", "Landroid/media/Image;", "dstBuffer", "Ljava/nio/ByteBuffer;", "<init>", "(Landroid/media/Image;Ljava/nio/ByteBuffer;)V", "type", "", "getType$annotations", "()V", "getType", "()I", "buffer", "getBuffer", "()Ljava/nio/ByteBuffer;", "removePadding", "", "Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer$ImageWrapper;", "removePaddingCompact", "plane", "Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer$PlaneWrapper;", "dst", "offset", "removePaddingNotCompact", "clipBuffer", "start", "size", "ImageWrapper", "PlaneWrapper", "lib_release"})
public final class YuvByteBuffer {
    private final int type;
    @NotNull
    private final ByteBuffer buffer;

    public YuvByteBuffer(@NotNull Image image, @Nullable ByteBuffer dstBuffer) {
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ImageWrapper wrappedImage = new ImageWrapper(image);
        this.type = wrappedImage.getU().getPixelStride() == 1 ? 35 : 17;
        int size = image.getWidth() * image.getHeight() * 3 / 2;
        if (dstBuffer == null || dstBuffer.capacity() < size || dstBuffer.isReadOnly() || !dstBuffer.isDirect()) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(size);
            Intrinsics.checkNotNull((Object)byteBuffer2);
            byteBuffer = byteBuffer2;
        } else {
            byteBuffer = dstBuffer;
        }
        this.buffer = byteBuffer;
        this.buffer.rewind();
        this.removePadding(wrappedImage);
    }

    public /* synthetic */ YuvByteBuffer(Image image, ByteBuffer byteBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            byteBuffer = null;
        }
        this(image, byteBuffer);
    }

    public final int getType() {
        return this.type;
    }

    public static /* synthetic */ void getType$annotations() {
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    private final void removePadding(ImageWrapper image) {
        int sizeLuma = image.getY().getWidth() * image.getY().getHeight();
        int sizeChroma = image.getU().getWidth() * image.getU().getHeight();
        if (image.getY().getRowStride() > image.getY().getWidth()) {
            this.removePaddingCompact(image.getY(), this.buffer, 0);
        } else {
            this.buffer.position(0);
            this.buffer.put(image.getY().getBuffer());
        }
        if (this.type == 35) {
            if (image.getU().getRowStride() > image.getU().getWidth()) {
                this.removePaddingCompact(image.getU(), this.buffer, sizeLuma);
                this.removePaddingCompact(image.getV(), this.buffer, sizeLuma + sizeChroma);
            } else {
                this.buffer.position(sizeLuma);
                this.buffer.put(image.getU().getBuffer());
                this.buffer.position(sizeLuma + sizeChroma);
                this.buffer.put(image.getV().getBuffer());
            }
        } else if (image.getU().getRowStride() > image.getU().getWidth() * 2) {
            this.removePaddingNotCompact(image, this.buffer, sizeLuma);
        } else {
            this.buffer.position(sizeLuma);
            ByteBuffer uv = image.getV().getBuffer();
            int properUVSize = image.getV().getHeight() * image.getV().getRowStride() - 1;
            if (uv.capacity() > properUVSize) {
                uv = this.clipBuffer(image.getV().getBuffer(), 0, properUVSize);
            }
            this.buffer.put(uv);
            byte lastOne = image.getU().getBuffer().get(image.getU().getBuffer().capacity() - 1);
            this.buffer.put(this.buffer.capacity() - 1, lastOne);
        }
        this.buffer.rewind();
    }

    private final void removePaddingCompact(PlaneWrapper plane, ByteBuffer dst, int offset) {
        if (!(plane.getPixelStride() == 1)) {
            boolean $i$a$-require-YuvByteBuffer$removePaddingCompact$22 = false;
            String $i$a$-require-YuvByteBuffer$removePaddingCompact$22 = "use removePaddingCompact with pixelStride == 1";
            throw new IllegalArgumentException($i$a$-require-YuvByteBuffer$removePaddingCompact$22.toString());
        }
        ByteBuffer src = plane.getBuffer();
        int rowStride = plane.getRowStride();
        ByteBuffer row = null;
        dst.position(offset);
        int n = plane.getHeight();
        for (int i = 0; i < n; ++i) {
            row = this.clipBuffer(src, i * rowStride, plane.getWidth());
            dst.put(row);
        }
    }

    private final void removePaddingNotCompact(ImageWrapper image, ByteBuffer dst, int offset) {
        if (!(image.getU().getPixelStride() == 2)) {
            boolean $i$a$-require-YuvByteBuffer$removePaddingNotCompact$22 = false;
            String $i$a$-require-YuvByteBuffer$removePaddingNotCompact$22 = "use removePaddingNotCompact pixelStride == 2";
            throw new IllegalArgumentException($i$a$-require-YuvByteBuffer$removePaddingNotCompact$22.toString());
        }
        int width = image.getU().getWidth();
        int height = image.getU().getHeight();
        int rowStride = image.getU().getRowStride();
        ByteBuffer row = null;
        dst.position(offset);
        int n = height - 1;
        for (int i = 0; i < n; ++i) {
            row = this.clipBuffer(image.getV().getBuffer(), i * rowStride, width * 2);
            dst.put(row);
        }
        row = this.clipBuffer(image.getU().getBuffer(), (height - 1) * rowStride - 1, width * 2);
        dst.put(row);
    }

    private final ByteBuffer clipBuffer(ByteBuffer buffer, int start2, int size) {
        ByteBuffer duplicate = buffer.duplicate();
        duplicate.position(start2);
        duplicate.limit(start2 + size);
        ByteBuffer byteBuffer = duplicate.slice();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"slice(...)");
        return byteBuffer;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u0014"}, d2={"Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer$ImageWrapper;", "", "image", "Landroid/media/Image;", "<init>", "(Landroid/media/Image;)V", "width", "", "getWidth", "()I", "height", "getHeight", "y", "Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer$PlaneWrapper;", "getY", "()Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer$PlaneWrapper;", "u", "getU", "v", "getV", "lib_release"})
    private static final class ImageWrapper {
        private final int width;
        private final int height;
        @NotNull
        private final PlaneWrapper y;
        @NotNull
        private final PlaneWrapper u;
        @NotNull
        private final PlaneWrapper v;

        public ImageWrapper(@NotNull Image image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.width = image.getWidth();
            this.height = image.getHeight();
            Image.Plane plane = image.getPlanes()[0];
            Intrinsics.checkNotNullExpressionValue((Object)plane, (String)"get(...)");
            this.y = new PlaneWrapper(this.width, this.height, plane);
            int n = this.width / 2;
            int n2 = this.height / 2;
            Image.Plane plane2 = image.getPlanes()[1];
            Intrinsics.checkNotNullExpressionValue((Object)plane2, (String)"get(...)");
            this.u = new PlaneWrapper(n, n2, plane2);
            int n3 = this.width / 2;
            int n4 = this.height / 2;
            Image.Plane plane3 = image.getPlanes()[2];
            Intrinsics.checkNotNullExpressionValue((Object)plane3, (String)"get(...)");
            this.v = new PlaneWrapper(n3, n4, plane3);
            if (!(this.y.getPixelStride() == 1)) {
                boolean $i$a$-require-YuvByteBuffer$ImageWrapper$42 = false;
                String $i$a$-require-YuvByteBuffer$ImageWrapper$42 = "Pixel stride for Y plane must be 1 but got " + this.y.getPixelStride() + " instead.";
                throw new IllegalArgumentException($i$a$-require-YuvByteBuffer$ImageWrapper$42.toString());
            }
            if (!(this.u.getPixelStride() == this.v.getPixelStride() && this.u.getRowStride() == this.v.getRowStride())) {
                boolean $i$a$-require-YuvByteBuffer$ImageWrapper$52 = false;
                String $i$a$-require-YuvByteBuffer$ImageWrapper$52 = "U and V planes must have the same pixel and row strides but got pixel=" + this.u.getPixelStride() + " row=" + this.u.getRowStride() + " for U and pixel=" + this.v.getPixelStride() + " and row=" + this.v.getRowStride() + " for V";
                throw new IllegalArgumentException($i$a$-require-YuvByteBuffer$ImageWrapper$52.toString());
            }
            if (!(this.u.getPixelStride() == 1 || this.u.getPixelStride() == 2)) {
                boolean bl = false;
                String string = "Supported pixel strides for U and V planes are 1 and 2";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final PlaneWrapper getY() {
            return this.y;
        }

        @NotNull
        public final PlaneWrapper getU() {
            return this.u;
        }

        @NotNull
        public final PlaneWrapper getV() {
            return this.v;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u0014"}, d2={"Llive/hms/video/media/capturers/camera/utils/YuvByteBuffer$PlaneWrapper;", "", "width", "", "height", "plane", "Landroid/media/Image$Plane;", "<init>", "(IILandroid/media/Image$Plane;)V", "getWidth", "()I", "getHeight", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "rowStride", "getRowStride", "pixelStride", "getPixelStride", "lib_release"})
    private static final class PlaneWrapper {
        private final int width;
        private final int height;
        @NotNull
        private final ByteBuffer buffer;
        private final int rowStride;
        private final int pixelStride;

        public PlaneWrapper(int width, int height, @NotNull Image.Plane plane) {
            Intrinsics.checkNotNullParameter((Object)plane, (String)"plane");
            this.width = width;
            this.height = height;
            ByteBuffer byteBuffer = plane.getBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getBuffer(...)");
            this.buffer = byteBuffer;
            this.rowStride = plane.getRowStride();
            this.pixelStride = plane.getPixelStride();
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @NotNull
        public final ByteBuffer getBuffer() {
            return this.buffer;
        }

        public final int getRowStride() {
            return this.rowStride;
        }

        public final int getPixelStride() {
            return this.pixelStride;
        }
    }
}

