/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.capturers.camera;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.util.Range;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.SafeContinuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import live.hms.video.media.capturers.camera.utils.ImageCaptureModel;
import live.hms.video.utils.HMSUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\b\u001a\u00020\t*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u0012\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a%\u0010\u0013\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"computeExifOrientation", "", "mirrored", "", "computeRelativeRotation", "Landroid/content/Context;", "cameraId", "", "getCameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "context", "getExposureMaxMeteringRegionsSupported", "getFocusMaxMeteringRegionsSupported", "getLensDistanceRange", "Landroid/util/Range;", "", "getWhiteBalanceMeteringRegionsSupported", "getZoomRatioRange", "isFlashAvailable", "saveResult", "", "result", "Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;", "filePathToSave", "Ljava/io/File;", "(Landroid/content/Context;Llive/hms/video/media/capturers/camera/utils/ImageCaptureModel;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib_release"})
@SourceDebugExtension(value={"SMAP\nCameraExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraExt.kt\nlive/hms/video/media/capturers/camera/CameraExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,187:1\n1#2:188\n*E\n"})
public final class CameraExtKt {
    public static final boolean isFlashAvailable(@NotNull Context $this$isFlashAvailable, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlashAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Boolean bl = (Boolean)CameraExtKt.getCameraCharacteristics($this$isFlashAvailable, cameraId).get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        return bl == null ? false : bl;
    }

    public static final int getWhiteBalanceMeteringRegionsSupported(@NotNull Context $this$getWhiteBalanceMeteringRegionsSupported, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getWhiteBalanceMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Integer n = (Integer)CameraExtKt.getCameraCharacteristics($this$getWhiteBalanceMeteringRegionsSupported, cameraId).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
        return n == null ? 0 : n;
    }

    public static final int getExposureMaxMeteringRegionsSupported(@NotNull Context $this$getExposureMaxMeteringRegionsSupported, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureMaxMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Integer n = (Integer)CameraExtKt.getCameraCharacteristics($this$getExposureMaxMeteringRegionsSupported, cameraId).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        return n == null ? 0 : n;
    }

    @NotNull
    public static final Range<Float> getZoomRatioRange(@NotNull Context $this$getZoomRatioRange, @NotNull String cameraId) {
        Range range;
        Intrinsics.checkNotNullParameter((Object)$this$getZoomRatioRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        if (Build.VERSION.SDK_INT >= 30) {
            range = (Range)CameraExtKt.getCameraCharacteristics($this$getZoomRatioRange, cameraId).get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
            if (range == null) {
                range = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
            }
        } else {
            Float f = (Float)CameraExtKt.getCameraCharacteristics($this$getZoomRatioRange, cameraId).get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
            if (f != null) {
                Float maxZoom = f;
                boolean bl = false;
                range = new Range((Comparable)Float.valueOf(1.0f), (Comparable)maxZoom);
            } else {
                range = new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
            }
        }
        return range;
    }

    public static final int getFocusMaxMeteringRegionsSupported(@NotNull Context $this$getFocusMaxMeteringRegionsSupported, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getFocusMaxMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Integer n = (Integer)CameraExtKt.getCameraCharacteristics($this$getFocusMaxMeteringRegionsSupported, cameraId).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        return n == null ? 0 : n;
    }

    public static final int computeRelativeRotation(@NotNull Context $this$computeRelativeRotation, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$computeRelativeRotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        CameraCharacteristics characteristics = CameraExtKt.getCameraCharacteristics($this$computeRelativeRotation, cameraId);
        Integer n = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        if (n == null) {
            n = 0;
        }
        int sensorOrientationDegrees = ((Number)n).intValue();
        Integer n2 = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
        boolean invertDeviceOrientationReadings = n2 != null ? n2 == 1 : false;
        int rotation = invertDeviceOrientationReadings ? 360 - HMSUtils.INSTANCE.getOrientation($this$computeRelativeRotation) : HMSUtils.INSTANCE.getOrientation($this$computeRelativeRotation);
        return (sensorOrientationDegrees + rotation) % 360;
    }

    @NotNull
    public static final CameraCharacteristics getCameraCharacteristics(@NotNull Context $this$getCameraCharacteristics, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraCharacteristics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Object object = $this$getCameraCharacteristics.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager cameraManager = (CameraManager)object;
        CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraId);
        Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"cameraManager.getCameraCharacteristics(cameraId)");
        return cameraCharacteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Nullable
    public static final Object saveResult(@NotNull Context $this$saveResult, @NotNull ImageCaptureModel result2, @NotNull File filePathToSave, @NotNull Continuation<? super Unit> $completion) {
        Continuation<? super Unit> continuation = $completion;
        SafeContinuation safeContinuation = new SafeContinuation(IntrinsicsKt.intercepted(continuation));
        Continuation cont = (Continuation)safeContinuation;
        boolean bl = false;
        switch (result2.getFormat()) {
            case 256: 
            case 1768253795: {
                void $this$saveResult_u24lambda_u244_u24lambda_u2433333332;
                byte[] byArray;
                ByteBuffer buffer = result2.getImage().getPlanes()[0].getBuffer();
                Object $this$saveResult_u24lambda_u244_u24lambda_u241 = byArray = new byte[buffer.remaining()];
                boolean $i$a$-apply-CameraExtKt$saveResult$2$bytes$23333335 = false;
                buffer.get((byte[])$this$saveResult_u24lambda_u244_u24lambda_u241);
                byte[] bytes = byArray;
                Ref.ObjectRef output = new Ref.ObjectRef();
                Object $i$a$-apply-CameraExtKt$saveResult$2$bytes$23333335 = $this$saveResult_u24lambda_u244_u24lambda_u241 = (Object)new FileOutputStream(filePathToSave);
                Ref.ObjectRef objectRef = output;
                boolean bl2 = false;
                $this$saveResult_u24lambda_u244_u24lambda_u2433333332.write(bytes);
                objectRef.element = $this$saveResult_u24lambda_u244_u24lambda_u241;
                cont.resumeWith(Result.constructor-impl((Object)Unit.INSTANCE));
                result2.close();
                try {
                    Unit unit;
                    boolean $i$a$-runCatching-CameraExtKt$saveResult$2$33333335 = false;
                    FileOutputStream fileOutputStream = (FileOutputStream)output.element;
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Object $i$a$-runCatching-CameraExtKt$saveResult$2$33333335 = Result.constructor-impl((Object)unit);
                }
                catch (Throwable $this$saveResult_u24lambda_u244_u24lambda_u2433333332) {
                    Object $i$a$-runCatching-CameraExtKt$saveResult$2$33333335 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$saveResult_u24lambda_u244_u24lambda_u2433333332));
                }
                break;
                catch (IOException exc) {
                    try {
                        cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exc)));
                        result2.close();
                    }
                    catch (Throwable throwable) {
                        result2.close();
                        try {
                            Unit unit;
                            boolean bl3 = false;
                            FileOutputStream fileOutputStream = (FileOutputStream)output.element;
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            Object object = Result.constructor-impl((Object)unit);
                        }
                        catch (Throwable throwable2) {
                            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        throw throwable;
                    }
                    try {
                        Unit unit;
                        boolean bl4 = false;
                        FileOutputStream fileOutputStream = (FileOutputStream)output.element;
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Object object = Result.constructor-impl((Object)unit);
                    }
                    catch (Throwable $this$saveResult_u24lambda_u244_u24lambda_u2433333332) {
                        Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$saveResult_u24lambda_u244_u24lambda_u2433333332));
                    }
                    break;
                }
            }
            default: {
                RuntimeException exc = new RuntimeException("Unknown image format: " + result2.getImage().getFormat());
                cont.resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)exc)));
            }
        }
        Object object = safeContinuation.getOrThrow();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final CameraCharacteristics getCameraCharacteristics(int $this$getCameraCharacteristics, @NotNull Context context) {
        Object var3_3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager manager = (CameraManager)object;
        try {
            String[] stringArray = manager.getCameraIdList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"manager.cameraIdList");
            String[] cameraIdList = stringArray;
            if ($this$getCameraCharacteristics < cameraIdList.length) {
                return manager.getCameraCharacteristics(cameraIdList[$this$getCameraCharacteristics]);
            }
            var3_3 = null;
        }
        catch (Exception ex) {
            var3_3 = null;
        }
        return var3_3;
    }

    @NotNull
    public static final Range<Float> getLensDistanceRange(@NotNull Context $this$getLensDistanceRange, @NotNull String cameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$getLensDistanceRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId, (String)"cameraId");
        Comparable comparable = Float.valueOf(0.0f);
        Float f = (Float)CameraExtKt.getCameraCharacteristics($this$getLensDistanceRange, cameraId).get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        if (f == null) {
            f = Float.valueOf(0.0f);
        }
        return new Range(comparable, (Comparable)f);
    }

    public static final int computeExifOrientation(int $this$computeExifOrientation, boolean mirrored) {
        return $this$computeExifOrientation == 0 && !mirrored ? 1 : ($this$computeExifOrientation == 0 && mirrored ? 2 : ($this$computeExifOrientation == 180 && !mirrored ? 3 : ($this$computeExifOrientation == 180 && mirrored ? 4 : ($this$computeExifOrientation == 270 && mirrored ? 7 : ($this$computeExifOrientation == 90 && !mirrored ? 6 : ($this$computeExifOrientation == 90 && mirrored ? 5 : ($this$computeExifOrientation == 270 && mirrored ? 8 : ($this$computeExifOrientation == 270 && !mirrored ? 7 : 0))))))));
    }
}

