/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.audio.BluetoothErrorType;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Llive/hms/video/audio/BluetoothPermissionHandler;", "", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "(Llive/hms/video/media/settings/HMSTrackSettings;)V", "BLUETOOTH_CONNECT_PERMISSION", "", "getBLUETOOTH_CONNECT_PERMISSION", "()Ljava/lang/String;", "getHmsTrackSettings", "()Llive/hms/video/media/settings/HMSTrackSettings;", "hasBluetoothError", "Llive/hms/video/audio/BluetoothErrorType;", "context", "Landroid/content/Context;", "hasPermission", "", "permission", "isDeviceAndroid12AndAbove", "isTargetingAndroid12AndAbove", "lib_release"})
public final class BluetoothPermissionHandler {
    @NotNull
    private final HMSTrackSettings hmsTrackSettings;
    @NotNull
    private final String BLUETOOTH_CONNECT_PERMISSION;

    public BluetoothPermissionHandler(@NotNull HMSTrackSettings hmsTrackSettings) {
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        this.hmsTrackSettings = hmsTrackSettings;
        this.BLUETOOTH_CONNECT_PERMISSION = "android.permission.BLUETOOTH_CONNECT";
    }

    @NotNull
    public final HMSTrackSettings getHmsTrackSettings() {
        return this.hmsTrackSettings;
    }

    @NotNull
    public final String getBLUETOOTH_CONNECT_PERMISSION() {
        return this.BLUETOOTH_CONNECT_PERMISSION;
    }

    private final boolean hasPermission(Context context, String permission) {
        return context.checkPermission(permission, Process.myPid(), Process.myUid()) == 0;
    }

    @Nullable
    public final BluetoothErrorType hasBluetoothError(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean noBluetoothPermission = !this.hasPermission(context, "android.permission.BLUETOOTH");
        BluetoothErrorType error = null;
        HMSAudioTrackSettings hMSAudioTrackSettings = this.hmsTrackSettings.getAudioSettings();
        boolean bl = hMSAudioTrackSettings != null ? hMSAudioTrackSettings.getDisableInternalAudioManager() : false;
        if (bl) {
            error = null;
        } else if (noBluetoothPermission) {
            error = BluetoothErrorType.NO_BLUETOOTH_PERMISSON;
        }
        return error;
    }

    private final boolean isDeviceAndroid12AndAbove() {
        return Build.VERSION.SDK_INT > 30;
    }

    private final boolean isTargetingAndroid12AndAbove(Context context) {
        return context.getApplicationInfo().targetSdkVersion > 30;
    }
}

