/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories.noisecancellation;

import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.factories.noisecancellation.NoiseCancellation;
import org.jetbrains.annotations.NotNull;
import org.webrtc.AudioProcessingFactory;
import org.webrtc.KrispAudioProcessingImpl;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0006H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Llive/hms/video/factories/noisecancellation/NoiseCancellationImpl;", "Llive/hms/video/factories/noisecancellation/NoiseCancellation;", "krisp", "Lorg/webrtc/KrispAudioProcessingImpl;", "isNoiseCancellationFlagEnabled", "Lkotlin/Function0;", "", "(Lorg/webrtc/KrispAudioProcessingImpl;Lkotlin/jvm/functions/Function0;)V", "getAudioProcessingFactory", "Lorg/webrtc/AudioProcessingFactory;", "enabled", "getNoiseCancellationEnabled", "setNoiseCancellationEnabled", "", "lib_release"})
public final class NoiseCancellationImpl
implements NoiseCancellation {
    @NotNull
    private final KrispAudioProcessingImpl krisp;
    @NotNull
    private final Function0<Boolean> isNoiseCancellationFlagEnabled;

    public NoiseCancellationImpl(@NotNull KrispAudioProcessingImpl krisp, @NotNull Function0<Boolean> isNoiseCancellationFlagEnabled) {
        Intrinsics.checkNotNullParameter((Object)krisp, (String)"krisp");
        Intrinsics.checkNotNullParameter(isNoiseCancellationFlagEnabled, (String)"isNoiseCancellationFlagEnabled");
        this.krisp = krisp;
        this.isNoiseCancellationFlagEnabled = isNoiseCancellationFlagEnabled;
    }

    @Override
    @NotNull
    public AudioProcessingFactory getAudioProcessingFactory(boolean enabled) {
        Log.d((String)this.getNcLogTag(), (String)("Noise Cancellation Loaded!, initial state " + enabled + ", dashboard " + (Boolean)this.isNoiseCancellationFlagEnabled.invoke()));
        this.setNoiseCancellationEnabled(enabled);
        return (AudioProcessingFactory)this.krisp;
    }

    @Override
    public void setNoiseCancellationEnabled(boolean enabled) {
        this.krisp.KrispDisable(!enabled || (Boolean)this.isNoiseCancellationFlagEnabled.invoke() == false);
    }

    @Override
    public boolean getNoiseCancellationEnabled() {
        return !this.krisp.IsKrispDisabled();
    }

    @Override
    @NotNull
    public String getNcLogTag() {
        return NoiseCancellation.DefaultImpls.getNcLogTag(this);
    }
}

