/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection.stats;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.degredation.Track;
import live.hms.video.media.settings.HMSLayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fRJ\u0010\u0003\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00060\u0004j\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Llive/hms/video/connection/stats/BitrateCalculator;", "", "()V", "prevTrackStatsReceivedTime", "Ljava/util/HashMap;", "", "Lkotlin/Pair;", "", "Ljava/math/BigInteger;", "Lkotlin/collections/HashMap;", "getBitrateFromTrackUpdatePrev", "stat", "Llive/hms/video/connection/degredation/Track;", "lib_release"})
public final class BitrateCalculator {
    @NotNull
    private final HashMap<String, Pair<Double, BigInteger>> prevTrackStatsReceivedTime = new HashMap();

    public final double getBitrateFromTrackUpdatePrev(@NotNull Track stat) {
        Intrinsics.checkNotNullParameter((Object)stat, (String)"stat");
        String trackIdentifier = stat.getTrackIdentifier();
        double bitrate = 0.0;
        if (stat.getTrackIdentifier() != null && stat.getRemoteTimestamp() != null) {
            double d;
            Pair<Double, BigInteger> prevInfo;
            Pair<Double, BigInteger> pair;
            HMSLayer hMSLayer;
            Track.LocalTrack.LocalVideo localVideo;
            Track.LocalTrack.LocalVideo localVideo2 = localVideo = stat instanceof Track.LocalTrack.LocalVideo ? (Track.LocalTrack.LocalVideo)stat : null;
            String simulcastPostFix = localVideo == null ? "" : ((hMSLayer = localVideo.getHmsLayer()) == null ? "" : ((pair = hMSLayer.name()) == null ? "" : pair));
            pair = prevInfo = this.prevTrackStatsReceivedTime.get(trackIdentifier + '_' + simulcastPostFix);
            Double prevTime = pair == null ? null : (Double)pair.getFirst();
            Pair<Double, BigInteger> pair2 = prevInfo;
            BigInteger prevBytesReceived = pair2 == null ? null : (BigInteger)pair2.getSecond();
            Double currentTime = stat.getRemoteTimestamp();
            BigInteger curBytesReceived = stat.getBytesTransported();
            if (prevBytesReceived != null && prevTime != null && curBytesReceived != null && currentTime != null) {
                double timeDelta = (currentTime - prevTime) / (double)1000000;
                d = (double)(0.008f * (curBytesReceived.floatValue() - prevBytesReceived.floatValue())) / timeDelta;
            } else {
                d = bitrate = 0.0;
            }
            if (trackIdentifier != null) {
                Map map = this.prevTrackStatsReceivedTime;
                String string = trackIdentifier + '_' + simulcastPostFix;
                Pair pair3 = new Pair((Object)currentTime, (Object)curBytesReceived);
                map.put(string, pair3);
            }
        }
        return bitrate;
    }
}

