/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.signal.jsonrpc;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import live.hms.video.connection.models.HMSSessionDescription;
import live.hms.video.connection.models.HMSTrickle;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.sdk.models.HMSHLSConfig;
import live.hms.video.sdk.models.HMSNotifications;
import live.hms.video.sdk.models.HMSRecordingConfig;
import live.hms.video.signal.HMSSignalMethod;
import live.hms.video.signal.ISignal;
import live.hms.video.signal.ISignalEventsObserver;
import live.hms.video.signal.jsonrpc.HMSWebSocketListener;
import live.hms.video.signal.jsonrpc.JSONRpcSignal;
import live.hms.video.signal.jsonrpc.models.HMSParams;
import live.hms.video.signal.jsonrpc.models.JsonRpcRequest;
import live.hms.video.utils.CoroutineExceptionTrackerKt;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.IdHelper;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 s2\u00020\u00012\u00020\u0002:\u0002rsB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001eH\u0016J5\u0010\u001f\u001a\u0002H \"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H 0&H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0019\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u0019\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*JE\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00072\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00010\n2\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u0001032\u0006\u00104\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J)\u0010-\u001a\u00020\u001d2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\n2\u0006\u0010.\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0011\u0010:\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J!\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\n2\u0006\u0010>\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020AH\u0016J1\u0010B\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\n2\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0011\u0010G\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0018\u0010H\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J'\u0010E\u001a\u00020\u001e2\u0006\u0010E\u001a\u00020\u001e2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J03H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ \u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001a2\u0006\u0010N\u001a\u00020O2\u0006\u0010=\u001a\u00020\nH\u0016J\"\u0010P\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010TH\u0016J\u0018\u0010U\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001a2\u0006\u0010V\u001a\u00020\nH\u0016J\u0018\u0010W\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020\u001a2\u0006\u0010S\u001a\u00020TH\u0016J\u0019\u0010X\u001a\u00020\u001d2\u0006\u0010Y\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J!\u0010Z\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\n2\u0006\u0010=\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J!\u0010\\\u001a\u00020\u001d2\u0006\u0010]\u001a\u00020\n2\u0006\u0010^\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J)\u0010_\u001a\u00020\u001d2\u0006\u0010`\u001a\u00020\n2\u0006\u0010a\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ\u0019\u0010c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010dJ\u001a\u0010e\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010f\u001a\u00020\nH\u0002J\u0019\u0010g\u001a\u00020\u001d2\u0006\u0010h\u001a\u00020iH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010jJ\u0019\u0010k\u001a\u00020\u001d2\u0006\u0010h\u001a\u00020lH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010mJ\u001b\u0010n\u001a\u00020\u001d2\b\u0010h\u001a\u0004\u0018\u00010iH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010jJ\u0011\u0010o\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0016\u0010p\u001a\u00020\u001d2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020J03H\u0016J\u0010\u0010q\u001a\u00020\u001d2\u0006\u0010q\u001a\u00020\u0017H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006t"}, d2={"Llive/hms/video/signal/jsonrpc/JSONRpcSignal;", "Llive/hms/video/signal/ISignal;", "Llive/hms/video/signal/jsonrpc/HMSWebSocketListener;", "observer", "Llive/hms/video/signal/ISignalEventsObserver;", "(Llive/hms/video/signal/ISignalEventsObserver;)V", "_isConnected", "", "callbacks", "Ljava/util/HashMap;", "", "Llive/hms/video/signal/jsonrpc/JSONRpcSignal$Callback;", "Lkotlin/collections/HashMap;", "isConnected", "()Z", "isJoinCompleted", "isLeaveInProgress", "getObserver", "()Llive/hms/video/signal/ISignalEventsObserver;", "onRoleChangeDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "pendingTrickle", "Ljava/util/ArrayList;", "Llive/hms/video/connection/models/HMSTrickle;", "Lkotlin/collections/ArrayList;", "socket", "Lokhttp3/WebSocket;", "webSocketOpenDeferred", "answer", "", "Llive/hms/video/connection/models/HMSSessionDescription;", "call", "T", "method", "Llive/hms/video/signal/HMSSignalMethod;", "params", "Llive/hms/video/signal/jsonrpc/models/HMSParams;", "c", "Ljava/lang/Class;", "(Llive/hms/video/signal/HMSSignalMethod;Llive/hms/video/signal/jsonrpc/models/HMSParams;Ljava/lang/Class;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeMetadata", "metadata", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changeName", "name", "changeTrackState", "mute", "type", "Llive/hms/video/media/tracks/HMSTrackType;", "source", "roles", "", "requestedByPeerId", "(ZLlive/hms/video/media/tracks/HMSTrackType;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hmsTrack", "Llive/hms/video/media/tracks/HMSTrack;", "peerId", "(Llive/hms/video/media/tracks/HMSTrack;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endRoom", "reason", "lock", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "event", "Llive/hms/video/events/AnalyticsEvent;", "join", "data", "serverSideSubscribeDegradation", "offer", "(Ljava/lang/String;Ljava/lang/String;ZLlive/hms/video/connection/models/HMSSessionDescription;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "leave", "notify", "tracks", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "(Llive/hms/video/connection/models/HMSSessionDescription;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onClosed", "webSocket", "code", "", "onFailure", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "onOpen", "open", "uri", "removePeer", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "roleChangeAccept", "token", "role", "roleChangeRequest", "forPeerId", "force", "(Ljava/lang/String;ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendMessage", "(Llive/hms/video/signal/jsonrpc/models/HMSParams;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendSocketMessage", "message", "startHLSStreaming", "config", "Llive/hms/video/sdk/models/HMSHLSConfig;", "(Llive/hms/video/sdk/models/HMSHLSConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startRtmpOrRecording", "Llive/hms/video/sdk/models/HMSRecordingConfig;", "(Llive/hms/video/sdk/models/HMSRecordingConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stopHLSStreaming", "stopRtmpAndRecording", "trackUpdate", "trickle", "Callback", "Companion", "lib_release"})
public final class JSONRpcSignal
extends HMSWebSocketListener
implements ISignal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ISignalEventsObserver observer;
    private boolean _isConnected;
    @NotNull
    private CompletableDeferred<Boolean> webSocketOpenDeferred;
    @NotNull
    private CompletableDeferred<Boolean> onRoleChangeDeferred;
    @Nullable
    private WebSocket socket;
    @NotNull
    private final HashMap<String, Callback> callbacks;
    @NotNull
    private final ArrayList<HMSTrickle> pendingTrickle;
    private boolean isJoinCompleted;
    private boolean isLeaveInProgress;
    @NotNull
    private static final String TAG = "JsonRPCSignal";

    public JSONRpcSignal(@NotNull ISignalEventsObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.observer = observer;
        this.webSocketOpenDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.onRoleChangeDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.callbacks = new HashMap();
        this.pendingTrickle = new ArrayList();
    }

    @Override
    @NotNull
    public ISignalEventsObserver getObserver() {
        return this.observer;
    }

    @Override
    public boolean isConnected() {
        return this._isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final <T> Object call(HMSSignalMethod var1_1, HMSParams var2_2, Class<T> var3_3, Continuation<? super T> var4_4) {
        if (!(var4_4 instanceof call.1)) ** GOTO lbl-1000
        var11_5 = var4_4;
        if ((var11_5.label & -2147483648) != 0) {
            var11_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSONRpcSignal.access$call(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                id = IdHelper.INSTANCE.makeCallSignalId();
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                message = new JsonRpcRequest(id, (HMSSignalMethod)method, (HMSParams)params).toJson();
                var8_11 = this.callbacks;
                var9_14 = new Callback((CompletableDeferred<String>)deferred, message, (HMSSignalMethod)method);
                var8_11.put(id, var9_14);
                HMSLogger.INSTANCE.v("JsonRPCSignal", "Sending ws message: [size=" + message.length() + "] " + message);
                this.sendSocketMessage(this.socket, message);
                $continuation.L$0 = this;
                $continuation.L$1 = c;
                $continuation.L$2 = id;
                $continuation.label = 1;
                v0 = deferred.await($continuation);
                ** if (v0 != var12_7) goto lbl30
lbl29:
                // 1 sources

                return var12_7;
lbl30:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                var5_8 = (String)$continuation.L$2;
                var3_3 = (Class)$continuation.L$1;
                this = (JSONRpcSignal)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    result = (String)v0;
                    this.callbacks.remove(var5_8);
                    var9_14 = GsonUtils.INSTANCE.getGson().fromJson(result, var3_3);
                    return var9_14;
                }
                catch (UninitializedPropertyAccessException var8_12) {
                    throw ErrorFactory.GenericErrors.NotConnected$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.NONE, "Websocket was either not initialized or not connected", null, null, 12, null);
                }
            }
            catch (Throwable var8_13) {
                throw var8_13;
            }
            {
                finally {
                    this.callbacks.remove(var5_8);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void sendSocketMessage(WebSocket socket, String message) {
        WebSocket webSocket = socket;
        Boolean sendResult = webSocket == null ? null : Boolean.valueOf(webSocket.send(message));
    }

    private final void notify(HMSSignalMethod method, HMSParams params) {
        String message = new JsonRpcRequest(method, params).toJson();
        HMSLogger.INSTANCE.v(TAG, "Sending ws message: [size=" + message.length() + "] " + message);
        this.sendSocketMessage(this.socket, message);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object open(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof open.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.open(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                HMSLogger.d("JsonRPCSignal", "open: Connecting WebSocket to endpoint=" + uri + " \u23f0");
                if (this.webSocketOpenDeferred.isCompleted()) {
                    this.webSocketOpenDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                }
                this.socket = OkHttpFactory.INSTANCE.makeWebSocket(uri, this);
                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.label = 1;
                v0 = this.webSocketOpenDeferred.await((Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                uri = (String)$continuation.L$1;
                this = (JSONRpcSignal)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                this._isConnected = true;
                HMSLogger.d("JsonRPCSignal", "open: WebSocket connected to endpoint=" + uri + " \u2705");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object join(@NotNull String var1_1, @NotNull String var2_2, boolean var3_3, @NotNull HMSSessionDescription var4_4, @NotNull Continuation<? super HMSSessionDescription> var5_5) {
        if (!(var5_5 instanceof join.1)) ** GOTO lbl-1000
        var15_6 = var5_5;
        if ((var15_6.label & -2147483648) != 0) {
            var15_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.join(null, null, false, null, (Continuation<? super HMSSessionDescription>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                params = new HMSParams.Join((String)name, (String)data, (HMSSessionDescription)offer, false, serverSideSubscribeDegradation != false, 8, null);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.call(HMSSignalMethod.JOIN, params, (Class<T>)HMSSessionDescription.class, (Continuation<? super T>)$continuation);
                if (v0 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (JSONRpcSignal)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                res = (HMSSessionDescription)v0;
                this.isJoinCompleted = true;
                $this$forEach$iv = this.pendingTrickle;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (HMSTrickle)element$iv;
                    $i$a$-forEach-JSONRpcSignal$join$2 = false;
                    this.trickle(it);
                }
                this.pendingTrickle.clear();
                return res;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object offer(@NotNull HMSSessionDescription offer, @NotNull List<HMSNotifications.Track> tracks, @NotNull Continuation<? super HMSSessionDescription> $completion) {
        HashMap<String, HMSNotifications.Track> tracksMap = new HashMap<String, HMSNotifications.Track>();
        for (HMSNotifications.Track track : tracks) {
            if (!StringsKt.contains$default((CharSequence)offer.getDescription(), (CharSequence)track.getTrackId(), (boolean)false, (int)2, null)) continue;
            Map map2 = tracksMap;
            String string = track.getTrackId();
            map2.put(string, track);
        }
        HMSParams.SendOffer params = new HMSParams.SendOffer(offer, tracksMap);
        return this.call(HMSSignalMethod.OFFER, params, HMSSessionDescription.class, $completion);
    }

    @Override
    public void answer(@NotNull HMSSessionDescription answer) {
        Intrinsics.checkNotNullParameter((Object)answer, (String)"answer");
        this.notify(HMSSignalMethod.ANSWER, new HMSParams.Answer(answer));
    }

    @Override
    public void trickle(@NotNull HMSTrickle trickle) {
        Intrinsics.checkNotNullParameter((Object)trickle, (String)"trickle");
        if (this.isJoinCompleted) {
            this.notify(HMSSignalMethod.TRICKLE, HMSParams.Trickle.Companion.from(trickle));
        } else {
            this.pendingTrickle.add(trickle);
        }
    }

    @Override
    @Nullable
    public Object sendMessage(@NotNull HMSParams params, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.BROADCAST, params, JsonObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void trackUpdate(@NotNull List<HMSNotifications.Track> tracks) {
        Intrinsics.checkNotNullParameter(tracks, (String)"tracks");
        HashMap tracksMap = new HashMap();
        for (HMSNotifications.Track track : tracks) {
            Map map2 = tracksMap;
            String string = track.getTrackId();
            map2.put(string, track);
        }
        HMSParams.TrackUpdate params = new HMSParams.TrackUpdate(tracksMap, null, 2, null);
        this.notify(HMSSignalMethod.TRACK_UPDATE, params);
    }

    @Override
    @Nullable
    public Object leave(@NotNull Continuation<? super Unit> $completion) {
        this.isLeaveInProgress = true;
        if (this._isConnected) {
            this.notify(HMSSignalMethod.LEAVE, new HMSParams.Leave("1.0"));
            Object object = this.close($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object roleChangeRequest(@NotNull String forPeerId, boolean force, @NotNull String role, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.ROLE_CHANGE_REQUEST, new HMSParams.RoleChangeRequest(forPeerId, force, role), JsonObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object roleChangeAccept(@NotNull String token, @NotNull String role, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.ROLE_CHANGE, new HMSParams.RoleChangeAccept(token, role), JsonObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object removePeer(@NotNull String peerId, @NotNull String reason, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.PEER_LEAVE_REQUEST, new HMSParams.RemovePeerRequest(peerId, reason), JsonObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object endRoom(@NotNull String var1_1, boolean var2_2, @NotNull Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof endRoom.1)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.endRoom(null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.call(HMSSignalMethod.END_ROOM, new HMSParams.EndRoomRequest(lock != false, (String)reason), (Class<T>)JsonObject.class, (Continuation<? super T>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return Boxing.boxBoolean((boolean)true);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object changeTrackState(@NotNull HMSTrack hmsTrack, @NotNull String peerId, boolean mute, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.TRACK_UPDATE_REQUEST, new HMSParams.TrackUpdateRequest(peerId, hmsTrack.getTrackId(), hmsTrack.getStream$lib_release().getId(), mute), JsonObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object changeTrackState(boolean mute, @Nullable HMSTrackType type, @Nullable String source, @Nullable List<String> roles, @NotNull String requestedByPeerId, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.CHANGE_TRACK_MUTE_STATE_REQUEST, new HMSParams.TrackUpdateAllRequest(null, roles, type, source, mute), JsonObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object startRtmpOrRecording(@NotNull HMSRecordingConfig config, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.RTMP_START, new HMSParams.RtmpStart(config.getMeetingUrl(), config.getRtmpUrls(), config.getRecord(), config.getResolution(), null, 16, null), JSONObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object startHLSStreaming(@NotNull HMSHLSConfig config, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.HLS_START, new HMSParams.HLSStart(config.getMeetingURLVariants(), config.getHmsHlsRecordingConfig()), JSONObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object stopHLSStreaming(@Nullable HMSHLSConfig config, @NotNull Continuation<? super Unit> $completion) {
        HMSHLSConfig hMSHLSConfig = config;
        Object object = this.call(HMSSignalMethod.HLS_STOP, new HMSParams.HLSStop(hMSHLSConfig == null ? null : hMSHLSConfig.getMeetingURLVariants()), JSONObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object stopRtmpAndRecording(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof stopRtmpAndRecording.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                final /* synthetic */ JSONRpcSignal this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stopRtmpAndRecording((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.call(HMSSignalMethod.RTMP_STOP, new HMSParams.RtmpStop(null, 1, null), (Class<T>)JSONObject.class, (Continuation<? super T>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                result = (JSONObject)v0;
                HMSLogger.d("JsonRPCSignal", Intrinsics.stringPlus((String)"Result was ", (Object)result));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object changeName(@NotNull String name, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.PEER_UPDATE, new HMSParams.PeerMetadataUpdate(name, null, null, 4, null), JSONObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object changeMetadata(@NotNull String metadata, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.call(HMSSignalMethod.PEER_UPDATE, new HMSParams.PeerMetadataUpdate(null, metadata, null, 4, null), JSONObject.class, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void event(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.notify(HMSSignalMethod.ANALYTICS, HMSParams.Event.Companion.from(event));
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        Boolean bl;
        if (this.socket == null || !this.isConnected()) {
            HMSLogger.INSTANCE.w(TAG, "close: Socket not yet initialized, ignoring `close()` call");
            return Unit.INSTANCE;
        }
        HMSLogger.d(TAG, "close: closing socket");
        WebSocket webSocket = this.socket;
        if (webSocket == null) {
            bl = null;
        } else {
            WebSocket webSocket2;
            WebSocket closingSocket = webSocket2 = webSocket;
            boolean bl2 = false;
            bl = Boxing.boxBoolean((boolean)closingSocket.close(1000, "Closing"));
        }
        if (bl == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return bl;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        super.onOpen(webSocket, response);
        this.webSocketOpenDeferred.complete((Object)true);
    }

    @Override
    public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this._isConnected = false;
        if (this.onRoleChangeDeferred.isActive()) {
            this.onRoleChangeDeferred.completeExceptionally(t);
        }
        this.onRoleChangeDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        if (this.isLeaveInProgress) {
            this.isLeaveInProgress = false;
            return;
        }
        super.onFailure(webSocket, t, response);
        Pair[] pairArray = t.getMessage();
        HMSException error = ErrorFactory.WebSocketConnectionErrors.WebSocketConnectionLost$default(ErrorFactory.WebSocketConnectionErrors.INSTANCE, ErrorFactory.Action.NONE, (String)(pairArray == null ? "WebSocket Disconnected" : pairArray), t, null, 8, null);
        if (response != null && (response.code() == 401 || response.code() == 403)) {
            Request request;
            WebSocket webSocket2 = this.socket;
            pairArray = new Pair[]{TuplesKt.to((Object)"endpoint", (Object)String.valueOf(webSocket2 == null ? null : ((request = webSocket2.request()) == null ? null : request.url()))), TuplesKt.to((Object)"response_code", (Object)response.code()), TuplesKt.to((Object)"response", (Object)response.toString())};
            error = ErrorFactory.InitAPIErrors.INSTANCE.HTTPError(response.code(), ErrorFactory.Action.INIT, "Token Not Authorized", t, MapsKt.hashMapOf((Pair[])pairArray));
        }
        if (this.webSocketOpenDeferred.isCompleted()) {
            this.getObserver().onFailure(error);
        } else {
            this.webSocketOpenDeferred.completeExceptionally((Throwable)error);
        }
    }

    @Override
    public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super.onMessage(webSocket, text);
        JsonObject response = (JsonObject)GsonUtils.INSTANCE.getGson().fromJson(text, JsonObject.class);
        if (response.has("id")) {
            String id = response.get("id").getAsString();
            if (this.callbacks.containsKey(id)) {
                Callback callback = this.callbacks.remove(id);
                Intrinsics.checkNotNull((Object)callback);
                Object object = callback;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"callbacks.remove(id)!!");
                Callback cb = object;
                if (response.has("result")) {
                    CompletableDeferred<String> completableDeferred = cb.getDeferred();
                    object = response.get("result").toString();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.get(\"result\").toString()");
                    completableDeferred.complete(object);
                } else {
                    HMSLogger.e(TAG, "Server Side Error: [size=" + text.length() + "] " + text);
                    JsonObject error = response.getAsJsonObject("error");
                    int n = error.get("code").getAsInt();
                    ErrorFactory.Action action = cb.getMethod().toErrorAction();
                    String string = error.get("message").getAsString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"error.get(\"message\").asString");
                    HMSException ex = ErrorFactory.WebsocketMethodErrors.ServerErrors$default(ErrorFactory.WebsocketMethodErrors.INSTANCE, n, action, string, null, null, 24, null);
                    cb.getDeferred().completeExceptionally((Throwable)ex);
                }
            } else {
                BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)CoroutineExceptionTrackerKt.exceptionSurfacer(TAG)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, response, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ JsonObject $response;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ISignalEventsObserver iSignalEventsObserver = this.this$0.getObserver();
                                JsonObject jsonObject = this.$response;
                                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"response");
                                iSignalEventsObserver.onNotification(jsonObject);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        } else if (response.has("method")) {
            String methodStr = response.get("method").getAsString();
            if (Intrinsics.areEqual((Object)methodStr, (Object)"on-policy-change") && !this.onRoleChangeDeferred.isCompleted()) {
                this.onRoleChangeDeferred.complete((Object)true);
            }
            Intrinsics.checkNotNullExpressionValue((Object)methodStr, (String)"methodStr");
            HMSSignalMethod method = HMSSignalMethod.Companion.from(methodStr);
            if (method == HMSSignalMethod.SDK_NOTIFICATION) {
                BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, (CoroutineContext)((CoroutineContext)CoroutineExceptionTrackerKt.exceptionSurfacer(TAG)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, response, null){
                    int label;
                    final /* synthetic */ JSONRpcSignal this$0;
                    final /* synthetic */ JsonObject $response;
                    {
                        this.this$0 = $receiver;
                        this.$response = $response;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                ISignalEventsObserver iSignalEventsObserver = this.this$0.getObserver();
                                JsonObject jsonObject = this.$response;
                                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"response");
                                iSignalEventsObserver.onNotification(jsonObject);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return;
            }
            Object object = response.get("params").getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.get(\"params\").asJsonObject");
            HMSParams params = HMSParams.Companion.fromReceivedParams(method, (JsonObject)object);
            if (params instanceof HMSParams.Unsupported) {
                HMSLogger.INSTANCE.w(TAG, Intrinsics.stringPlus((String)"Ignoring unsupported notification: ", (Object)response.get("params")));
                return;
            }
            HMSLogger.INSTANCE.v(TAG, "[method=" + (Object)((Object)method) + "] Received params=" + params);
            object = method;
            int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
            switch (n) {
                case 1: {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, params, null){
                        int label;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ HMSParams $params;
                        {
                            this.this$0 = $receiver;
                            this.$params = $params;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.this$0.getObserver().onTrickle(((HMSParams.Trickle)this.$params).toTrickle());
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                case 2: {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, params, null){
                        int label;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ HMSParams $params;
                        {
                            this.this$0 = $receiver;
                            this.$params = $params;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.this$0.getObserver().onOffer(((HMSParams.Offer)this.$params).toSDP(), (Continuation<? super Unit>)((Continuation)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                case 3: {
                    BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(params, this, method, null){
                        int label;
                        final /* synthetic */ HMSParams $params;
                        final /* synthetic */ JSONRpcSignal this$0;
                        final /* synthetic */ HMSSignalMethod $method;
                        {
                            this.$params = $params;
                            this.this$0 = $receiver;
                            this.$method = $method;
                            super(2, $completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    HMSParams.OnError cfr_ignored_0 = (HMSParams.OnError)this.$params;
                                    this.this$0.getObserver().onServerError(ErrorFactory.WebsocketMethodErrors.ServerErrors$default(ErrorFactory.WebsocketMethodErrors.INSTANCE, ((HMSParams.OnError)this.$params).getCode(), this.$method.toErrorAction(), ((HMSParams.OnError)this.$params).getMessage(), null, null, 24, null));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                    break;
                }
                default: {
                    HMSLogger.INSTANCE.w(TAG, "Received unknown " + (Object)((Object)method) + " message from server, [size=" + text.length() + "] " + text);
                    break;
                }
            }
        } else {
            HMSLogger.INSTANCE.w(TAG, Intrinsics.stringPlus((String)"WebSocket message has no `method` or `id` field, message=", (Object)response));
        }
    }

    @Override
    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super.onClosed(webSocket, code, reason);
        this.isLeaveInProgress = false;
        this._isConnected = false;
    }

    public static final /* synthetic */ Object access$call(JSONRpcSignal $this, HMSSignalMethod method, HMSParams params, Class c, Continuation $completion) {
        return $this.call(method, params, c, $completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/signal/jsonrpc/JSONRpcSignal$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Llive/hms/video/signal/jsonrpc/JSONRpcSignal$Callback;", "", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "message", "method", "Llive/hms/video/signal/HMSSignalMethod;", "(Lkotlinx/coroutines/CompletableDeferred;Ljava/lang/String;Llive/hms/video/signal/HMSSignalMethod;)V", "getDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "getMessage", "()Ljava/lang/String;", "getMethod", "()Llive/hms/video/signal/HMSSignalMethod;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
    private static final class Callback {
        @NotNull
        private final CompletableDeferred<String> deferred;
        @NotNull
        private final String message;
        @NotNull
        private final HMSSignalMethod method;

        public Callback(@NotNull CompletableDeferred<String> deferred, @NotNull String message, @NotNull HMSSignalMethod method) {
            Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            this.deferred = deferred;
            this.message = message;
            this.method = method;
        }

        @NotNull
        public final CompletableDeferred<String> getDeferred() {
            return this.deferred;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final HMSSignalMethod getMethod() {
            return this.method;
        }

        @NotNull
        public final CompletableDeferred<String> component1() {
            return this.deferred;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final HMSSignalMethod component3() {
            return this.method;
        }

        @NotNull
        public final Callback copy(@NotNull CompletableDeferred<String> deferred, @NotNull String message, @NotNull HMSSignalMethod method) {
            Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            return new Callback(deferred, message, method);
        }

        public static /* synthetic */ Callback copy$default(Callback callback, CompletableDeferred completableDeferred, String string, HMSSignalMethod hMSSignalMethod, int n, Object object) {
            if ((n & 1) != 0) {
                completableDeferred = callback.deferred;
            }
            if ((n & 2) != 0) {
                string = callback.message;
            }
            if ((n & 4) != 0) {
                hMSSignalMethod = callback.method;
            }
            return callback.copy(completableDeferred, string, hMSSignalMethod);
        }

        @NotNull
        public String toString() {
            return "Callback(deferred=" + this.deferred + ", message=" + this.message + ", method=" + (Object)((Object)this.method) + ')';
        }

        public int hashCode() {
            int result = this.deferred.hashCode();
            result = result * 31 + this.message.hashCode();
            result = result * 31 + this.method.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Callback)) {
                return false;
            }
            Callback callback = (Callback)other;
            if (!Intrinsics.areEqual(this.deferred, callback.deferred)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)callback.message)) {
                return false;
            }
            return this.method == callback.method;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSSignalMethod.values().length];
            nArray[HMSSignalMethod.TRICKLE.ordinal()] = 1;
            nArray[HMSSignalMethod.OFFER.ordinal()] = 2;
            nArray[HMSSignalMethod.SERVER_ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

