/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={StringRedisTemplate.class})
public class SimpleRedisTemplate {
    private static final Logger log = LoggerFactory.getLogger(SimpleRedisTemplate.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public Boolean setIfAbsent(String key, String value, long timeoutMillis) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void convertAndSend(String channel, String message) {
        this.stringRedisTemplate.convertAndSend(channel, (Object)message);
    }

    public HashOperations<String, String, String> opsForHash() {
        return this.stringRedisTemplate.opsForHash();
    }

    public ValueOperations<String, String> opsForValue() {
        return this.stringRedisTemplate.opsForValue();
    }

    public ListOperations<String, String> opsForList() {
        return this.stringRedisTemplate.opsForList();
    }
}

