/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis.message;

import java.util.Collections;
import java.util.List;
import link.thingscloud.spring.boot.common.redis.annotation.RedisTopic;
import link.thingscloud.spring.boot.common.redis.message.RedisMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
public class RedisMessageListenerConfig {
    private static final Logger log = LoggerFactory.getLogger(RedisMessageListenerConfig.class);
    @Autowired(required=false)
    private final List<RedisMessageListener> redisMessageListeners = Collections.emptyList();

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        this.redisMessageListeners.forEach(listener -> {
            RedisTopic redisTopic;
            String topic = listener.getTopic();
            if (topic == null && (redisTopic = listener.getClass().getAnnotation(RedisTopic.class)) != null) {
                topic = redisTopic.value();
            }
            if (topic == null) {
                log.warn("redis message listener {}, topic is null, please use RedisTopic Annotation or implementation getTopic method", (Object)listener.getClass().getName());
                return;
            }
            log.info("redis message listener topic : {}, listener : {}", (Object)topic, (Object)listener.getClass().getName());
            container.addMessageListener((MessageListener)listener, (Topic)new PatternTopic(topic));
        });
        return container;
    }
}

