/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.thread.ThreadUtil;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import link.thingscloud.spring.boot.common.redis.callback.RedisResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.stereotype.Component;

@Component
public class SimpleDistributedLocker {
    private static final Logger log = LoggerFactory.getLogger(SimpleDistributedLocker.class);
    @Value(value="${simple.distributed.lock.sleepTimeout:10}")
    private long sleepTimeoutMillis;
    @Value(value="${simple.distributed.lock.lockTimeout:1000}")
    private long lockTimeoutMillis;
    @Value(value="${simple.distributed.lock.expiredTimeout:300000}")
    private long expiredTimeoutMillis;
    @Value(value="${simple.distributed.lock.key:simple:distributed:lock:}")
    private String lockKey;
    private static final RedisScript<Long> DELETE_VALUE_REDIS_SCRIPT = new DefaultRedisScript("if redis.call('GET', KEYS[1]) == ARGV[1] then  return redis.call('DEL', KEYS[1]) else return -1 end", Long.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public void tryLock(String key, RedisResponseCallback callback) {
        this.tryLock(key, this.expiredTimeoutMillis, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryLock(String key, long expiredTimeoutMillis, RedisResponseCallback callback) {
        Boolean lock;
        String value = DateUtil.now();
        try {
            lock = this.tryLock(this.lockKey + key, value, expiredTimeoutMillis);
        }
        catch (Exception e) {
            callback.onException(e);
            return;
        }
        if (lock.booleanValue()) {
            try {
                long start = System.currentTimeMillis();
                callback.onSucceed();
                long cost = System.currentTimeMillis() - start;
                if (cost >= expiredTimeoutMillis) {
                    log.warn("[lock] key : {}, expired timeout : {} ms, cost : {} ms, you should increment timeout!", new Object[]{key, expiredTimeoutMillis, cost});
                }
                log.debug("[lock] key : {}, expired timeout : {} ms, cost : {} ms", new Object[]{key, expiredTimeoutMillis, cost});
            }
            catch (Exception e) {
                callback.onException(e);
            }
            finally {
                this.deleteLock(this.lockKey + key, value);
            }
        } else {
            callback.onFailure();
        }
    }

    public void lock(String key, RedisResponseCallback callback) {
        this.lock(key, this.lockTimeoutMillis, this.expiredTimeoutMillis, callback);
    }

    public void lock(String key, long lockTimeoutMillis, RedisResponseCallback callback) {
        this.lock(key, lockTimeoutMillis, this.expiredTimeoutMillis, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, long lockTimeoutMillis, long expiredTimeoutMillis, RedisResponseCallback callback) {
        Boolean lock;
        int tryTimes = 0;
        String value = DateUtil.now();
        try {
            lock = this.tryLock(this.lockKey + key, value, expiredTimeoutMillis);
            while (!lock.booleanValue() && lockTimeoutMillis > 0L) {
                ++tryTimes;
                lockTimeoutMillis -= this.sleepTimeoutMillis;
                ThreadUtil.sleep((long)this.sleepTimeoutMillis);
                lock = this.tryLock(this.lockKey + key, value, expiredTimeoutMillis);
            }
        }
        catch (Exception e) {
            callback.onException(e);
            return;
        }
        if (lock.booleanValue()) {
            try {
                long start = System.currentTimeMillis();
                callback.onSucceed();
                long cost = System.currentTimeMillis() - start;
                if (cost >= expiredTimeoutMillis) {
                    log.warn("[lock] key : {}, lock timeout : {} ms, expired timeout : {} ms, tryTimes : {}, cost : {} ms, you should increment timeout!", new Object[]{key, lockTimeoutMillis, expiredTimeoutMillis, tryTimes, cost});
                }
                log.debug("[lock] key : {}, lock timeout : {} ms, expired timeout : {} ms, tryTimes : {} cost : {} ms", new Object[]{key, lockTimeoutMillis, expiredTimeoutMillis, tryTimes, cost});
            }
            catch (Exception e) {
                callback.onException(e);
            }
            finally {
                this.deleteLock(this.lockKey + key, value);
            }
        } else {
            callback.onFailure();
        }
    }

    private Boolean tryLock(String key, String value, long timeoutMillis) {
        return this.stringRedisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    private void deleteLock(String key, String value) {
        this.stringRedisTemplate.execute(DELETE_VALUE_REDIS_SCRIPT, Arrays.asList(key), new Object[]{value});
    }
}

