/*
 * Decompiled with CFR 0.152.
 */
package link.thingscloud.spring.boot.common.redis;

import cn.hutool.core.date.DateUtil;
import java.util.concurrent.TimeUnit;
import link.thingscloud.spring.boot.common.redis.AbstractRedisTemplate0;
import link.thingscloud.spring.boot.common.redis.RedisResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisTemplate0
extends AbstractRedisTemplate0 {
    private static final Logger log = LoggerFactory.getLogger(RedisTemplate0.class);
    private static final String NS_LOCK = "link:thingscloud:redis:lock:";

    public void lock(String key, RedisResponseCallback callback) {
        this.lock(key, 300000L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, long timeout, RedisResponseCallback callback) {
        Boolean lock = this.stringRedisTemplate.opsForValue().setIfAbsent((Object)(NS_LOCK + key), (Object)DateUtil.now(), timeout, TimeUnit.MILLISECONDS);
        if (lock != null && lock.booleanValue()) {
            try {
                long start = System.currentTimeMillis();
                callback.onSucceed();
                long cost = System.currentTimeMillis() - start;
                if (cost >= timeout) {
                    log.warn("[lock] key : {}, timeout : {} ms, cost : {} ms, you should increment timeout!", new Object[]{key, timeout, System.currentTimeMillis() - start});
                }
                log.info("[lock] key : {}, timeout : {} ms, cost : {} ms", new Object[]{key, timeout, System.currentTimeMillis() - start});
            }
            catch (Exception e) {
                callback.onException(e);
            }
            finally {
                this.stringRedisTemplate.delete((Object)(NS_LOCK + key));
            }
        } else {
            callback.onFailure();
        }
    }

    public void convertAndSend(String channel, String message) {
        this.stringRedisTemplate.convertAndSend(channel, (Object)message);
    }

    public HashOperations<String, String, String> opsForHash() {
        return this.stringRedisTemplate.opsForHash();
    }

    public ValueOperations<String, String> opsForValue() {
        return this.stringRedisTemplate.opsForValue();
    }
}

