/*
 * Decompiled with CFR 0.152.
 */
package lc.kra.system.mouse;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import lc.kra.system.GlobalHookMode;
import lc.kra.system.LibraryLoader;
import lc.kra.system.mouse.event.GlobalMouseEvent;
import lc.kra.system.mouse.event.GlobalMouseListener;

public class GlobalMouseHook {
    private static final int STATUS_SUCCESS = 0;
    private NativeMouseHook mouseHook;
    private BlockingQueue<GlobalMouseEvent> inputBuffer = new LinkedBlockingQueue<GlobalMouseEvent>();
    private int buttons = 0;
    private List<GlobalMouseListener> listeners = new CopyOnWriteArrayList<GlobalMouseListener>();
    private Thread eventDispatcher = new Thread(){
        {
            this.setName("Global Mouse Hook Dispatcher");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                while (GlobalMouseHook.this.isAlive()) {
                    GlobalMouseEvent event = (GlobalMouseEvent)GlobalMouseHook.this.inputBuffer.take();
                    switch (event.getTransitionState()) {
                        case 0: {
                            GlobalMouseHook.this.mouseReleased(event);
                            break;
                        }
                        case 1: {
                            GlobalMouseHook.this.mousePressed(event);
                            break;
                        }
                        case 2: {
                            GlobalMouseHook.this.mouseMoved(event);
                            break;
                        }
                        case 3: {
                            GlobalMouseHook.this.mouseWheel(event);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public GlobalMouseHook() throws UnsatisfiedLinkError {
        this(false);
    }

    public GlobalMouseHook(boolean raw) throws UnsatisfiedLinkError {
        this(raw ? GlobalHookMode.RAW : GlobalHookMode.DEFAULT);
    }

    public GlobalMouseHook(GlobalHookMode mode) throws UnsatisfiedLinkError {
        LibraryLoader.loadLibrary();
        this.mouseHook = new NativeMouseHook(mode){

            @Override
            public void handleMouse(int transitionState, int button, int x, int y, int delta, long deviceHandle) {
                GlobalMouseHook.this.inputBuffer.add(new GlobalMouseEvent(this, transitionState, button, GlobalMouseHook.this.buttons ^= button, x, y, delta, deviceHandle));
            }
        };
        this.eventDispatcher.start();
    }

    public void addMouseListener(GlobalMouseListener listener) {
        this.listeners.add(listener);
    }

    public void removeMouseListener(GlobalMouseListener listener) {
        this.listeners.remove(listener);
    }

    private void mousePressed(GlobalMouseEvent event) {
        for (GlobalMouseListener listener : this.listeners) {
            listener.mousePressed(event);
        }
    }

    private void mouseReleased(GlobalMouseEvent event) {
        for (GlobalMouseListener listener : this.listeners) {
            listener.mouseReleased(event);
        }
    }

    private void mouseMoved(GlobalMouseEvent event) {
        for (GlobalMouseListener listener : this.listeners) {
            listener.mouseMoved(event);
        }
    }

    private void mouseWheel(GlobalMouseEvent event) {
        for (GlobalMouseListener listener : this.listeners) {
            listener.mouseWheel(event);
        }
    }

    public boolean isAlive() {
        return this.mouseHook != null && this.mouseHook.isAlive();
    }

    public void shutdownHook() {
        if (this.isAlive()) {
            this.mouseHook.unregisterHook();
            try {
                this.mouseHook.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Map<Long, String> listMice() throws UnsatisfiedLinkError {
        LibraryLoader.loadLibrary();
        return NativeMouseHook.listDevices();
    }

    private static abstract class NativeMouseHook
    extends Thread {
        private int status;
        private GlobalHookMode mode;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NativeMouseHook(GlobalHookMode mode) {
            super("Global Mouse Hook Thread");
            this.setDaemon(false);
            this.setPriority(10);
            NativeMouseHook nativeMouseHook = this;
            synchronized (nativeMouseHook) {
                this.mode = mode;
                try {
                    this.start();
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.status != 0) {
                    throw new RuntimeException("Low-level mouse hook failed (" + this.status + ")");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.status = this.registerHook(this.mode.ordinal());
            NativeMouseHook nativeMouseHook = this;
            synchronized (nativeMouseHook) {
                this.notifyAll();
            }
        }

        public final native int registerHook(int var1);

        public final native void unregisterHook();

        public static final native Map<Long, String> listDevices();

        public abstract void handleMouse(int var1, int var2, int var3, int var4, int var5, long var6);
    }
}

