/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kg.apc.jmeter.reporters.AutoStop;

public class JAutoStopPanel
extends JPanel {
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelBulletError;
    private JLabel jLabelBulletLatency;
    private JLabel jLabelBulletRespTime;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTextField jTextFieldError;
    private JTextField jTextFieldErrorSec;
    private JTextField jTextFieldRespLatency;
    private JTextField jTextFieldRespLatencySec;
    private JTextField jTextFieldRespTime;
    private JTextField jTextFieldRespTimeSec;

    public JAutoStopPanel() {
        this.initComponents();
        this.registerJTextfieldForValidation(this.jTextFieldError, true);
        this.registerJTextfieldForValidation(this.jTextFieldErrorSec, false);
        this.registerJTextfieldForValidation(this.jTextFieldRespLatency, false);
        this.registerJTextfieldForValidation(this.jTextFieldRespLatencySec, false);
        this.registerJTextfieldForValidation(this.jTextFieldRespTime, false);
        this.registerJTextfieldForValidation(this.jTextFieldRespTimeSec, false);
        this.initFields();
    }

    public void configure(AutoStop testElement) {
        this.jTextFieldRespTime.setText(testElement.getResponseTime());
        this.jTextFieldRespTimeSec.setText(testElement.getResponseTimeSecs());
        this.jTextFieldError.setText(testElement.getErrorRate());
        this.jTextFieldErrorSec.setText(testElement.getErrorRateSecs());
        this.jTextFieldRespLatency.setText(testElement.getResponseLatency());
        this.jTextFieldRespLatencySec.setText(testElement.getResponseLatencySecs());
    }

    public void modifyTestElement(AutoStop testElement) {
        testElement.setResponseTime(this.jTextFieldRespTime.getText());
        testElement.setResponseTimeSecs(this.jTextFieldRespTimeSec.getText());
        testElement.setErrorRate(this.jTextFieldError.getText());
        testElement.setErrorRateSecs(this.jTextFieldErrorSec.getText());
        testElement.setResponseLatency(this.jTextFieldRespLatency.getText());
        testElement.setResponseLatencySecs(this.jTextFieldRespLatencySec.getText());
    }

    public final void initFields() {
        this.jTextFieldRespTime.setText("10000");
        this.jTextFieldRespTimeSec.setText("10");
        this.jTextFieldError.setText("50");
        this.jTextFieldErrorSec.setText("10");
        this.jTextFieldRespLatency.setText("5000");
        this.jTextFieldRespLatencySec.setText("10");
    }

    private int getIntValue(JTextField tf) {
        int ret;
        try {
            ret = Integer.valueOf(tf.getText());
        }
        catch (NumberFormatException ex) {
            ret = -1;
        }
        return ret;
    }

    private float getFloatValue(JTextField tf) {
        float ret;
        try {
            ret = Float.valueOf(tf.getText()).floatValue();
        }
        catch (NumberFormatException ex) {
            ret = -1.0f;
        }
        return ret;
    }

    private boolean isVariableValue(JTextField tf) {
        String value = tf.getText();
        if (value != null) {
            return value.startsWith("${") && value.endsWith("}");
        }
        return false;
    }

    private void processBullets() {
        this.jLabelBulletError.setEnabled(this.getFloatValue(this.jTextFieldError) > 0.0f || this.isVariableValue(this.jTextFieldError));
        this.jLabelBulletRespTime.setEnabled(this.getIntValue(this.jTextFieldRespTime) > 0 || this.isVariableValue(this.jTextFieldRespTime));
        this.jLabelBulletLatency.setEnabled(this.getIntValue(this.jTextFieldRespLatency) > 0 || this.isVariableValue(this.jTextFieldRespLatency));
    }

    private void setJTextFieldColor(JTextField tf, boolean isFloat) {
        if (!isFloat && (this.getIntValue(tf) > -1 || this.isVariableValue(tf))) {
            tf.setForeground(Color.black);
        } else if (isFloat && (this.getFloatValue(tf) > -1.0f || this.isVariableValue(tf))) {
            tf.setForeground(Color.black);
        } else {
            tf.setForeground(Color.red);
        }
    }

    private void registerJTextfieldForValidation(final JTextField tf, final boolean isFloat) {
        tf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                JAutoStopPanel.this.setJTextFieldColor(tf, isFloat);
                JAutoStopPanel.this.processBullets();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                JAutoStopPanel.this.setJTextFieldColor(tf, isFloat);
                JAutoStopPanel.this.processBullets();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                JAutoStopPanel.this.setJTextFieldColor(tf, isFloat);
                JAutoStopPanel.this.processBullets();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabelBulletRespTime = new JLabel();
        this.jLabel10 = new JLabel();
        this.jTextFieldRespTime = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldRespTimeSec = new JTextField();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabelBulletLatency = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextFieldRespLatency = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldRespLatencySec = new JTextField();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabelBulletError = new JLabel();
        this.jLabel12 = new JLabel();
        this.jTextFieldError = new JTextField();
        this.jLabel6 = new JLabel();
        this.jTextFieldErrorSec = new JTextField();
        this.jLabel7 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("Test Shutdown Criteria"));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 0, 12));
        this.jLabel1.setText("The test will be automatically stopped if:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabelBulletRespTime.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/reporters/bulletGreen.png")));
        this.jPanel1.add(this.jLabelBulletRespTime);
        this.jLabel10.setText("average Response Time is greater than");
        this.jPanel1.add(this.jLabel10);
        this.jTextFieldRespTime.setColumns(7);
        this.jTextFieldRespTime.setHorizontalAlignment(4);
        this.jTextFieldRespTime.setMaximumSize(new Dimension(100, 20));
        this.jPanel1.add(this.jTextFieldRespTime);
        this.jLabel2.setText("ms for");
        this.jPanel1.add(this.jLabel2);
        this.jTextFieldRespTimeSec.setColumns(5);
        this.jTextFieldRespTimeSec.setHorizontalAlignment(4);
        this.jTextFieldRespTimeSec.setInheritsPopupMenu(true);
        this.jTextFieldRespTimeSec.setMaximumSize(new Dimension(100, 20));
        this.jPanel1.add(this.jTextFieldRespTimeSec);
        this.jLabel3.setText("seconds");
        this.jPanel1.add(this.jLabel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabelBulletLatency.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/reporters/bulletGreen.png")));
        this.jPanel2.add(this.jLabelBulletLatency);
        this.jLabel11.setText("average Latency is greater than");
        this.jPanel2.add(this.jLabel11);
        this.jTextFieldRespLatency.setColumns(7);
        this.jTextFieldRespLatency.setHorizontalAlignment(4);
        this.jTextFieldRespLatency.setMaximumSize(new Dimension(100, 20));
        this.jPanel2.add(this.jTextFieldRespLatency);
        this.jLabel4.setText("ms for");
        this.jPanel2.add(this.jLabel4);
        this.jTextFieldRespLatencySec.setColumns(5);
        this.jTextFieldRespLatencySec.setHorizontalAlignment(4);
        this.jTextFieldRespLatencySec.setMaximumSize(new Dimension(100, 20));
        this.jPanel2.add(this.jTextFieldRespLatencySec);
        this.jLabel5.setText("seconds");
        this.jPanel2.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabelBulletError.setIcon(new ImageIcon(this.getClass().getResource("/kg/apc/jmeter/reporters/bulletGreen.png")));
        this.jPanel4.add(this.jLabelBulletError);
        this.jLabel12.setText("Error Rate is greater than");
        this.jPanel4.add(this.jLabel12);
        this.jTextFieldError.setColumns(5);
        this.jTextFieldError.setHorizontalAlignment(4);
        this.jTextFieldError.setMaximumSize(new Dimension(30, 20));
        this.jPanel4.add(this.jTextFieldError);
        this.jLabel6.setText("% for");
        this.jPanel4.add(this.jLabel6);
        this.jTextFieldErrorSec.setColumns(5);
        this.jTextFieldErrorSec.setHorizontalAlignment(4);
        this.jTextFieldErrorSec.setMaximumSize(new Dimension(100, 20));
        this.jPanel4.add(this.jTextFieldErrorSec);
        this.jLabel7.setText("seconds");
        this.jPanel4.add(this.jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jLabel8.setFont(new Font("Tahoma", 0, 10));
        this.jLabel8.setText("OR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setFont(new Font("Tahoma", 0, 10));
        this.jLabel9.setText("OR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.jLabel9, gridBagConstraints);
    }
}

