/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.reporters;

import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import kg.apc.charting.elements.GraphPanelChartAverageElement;
import org.apache.jmeter.JMeter;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class AutoStop
extends AbstractListenerElement
implements SampleListener,
Serializable,
TestListener,
Remoteable,
NoThreadClone {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String RESPONSE_TIME = "avg_response_time";
    private static final String ERROR_RATE = "error_rate";
    private static final String RESPONSE_TIME_SECS = "avg_response_time_length";
    private static final String ERROR_RATE_SECS = "error_rate_length";
    private static final String RESPONSE_LATENCY = "avg_response_latency";
    private static final String RESPONSE_LATENCY_SECS = "avg_response_latency_length";
    private long curSec = 0L;
    private GraphPanelChartAverageElement avgRespTime = new GraphPanelChartAverageElement();
    private GraphPanelChartAverageElement avgRespLatency = new GraphPanelChartAverageElement();
    private GraphPanelChartAverageElement errorRate = new GraphPanelChartAverageElement();
    private long respTimeExceededStart = 0L;
    private long errRateExceededStart = 0L;
    private long respLatencyExceededStart = 0L;
    private int stopTries = 0;
    private int testValueRespTime = 0;
    private int testValueRespTimeSec = 0;
    private int testValueRespLatency = 0;
    private int testValueRespLatencySec = 0;
    private float testValueError = 0.0f;
    private int testValueErrorSec = 0;

    public void sampleOccurred(SampleEvent se) {
        long sec = System.currentTimeMillis() / 1000L;
        if (this.curSec != sec) {
            if (this.testValueRespTime > 0) {
                if (this.avgRespTime.getValue() > (double)this.testValueRespTime) {
                    if (sec - this.respTimeExceededStart >= (long)this.testValueRespTimeSec) {
                        log.info("Average Response Time is more than " + this.getResponseTime() + " for " + this.getResponseTimeSecs() + "s. Auto-shutdown test...");
                        this.stopTest();
                    }
                } else {
                    this.respTimeExceededStart = sec;
                }
            }
            if (this.testValueRespLatency > 0) {
                if (this.avgRespLatency.getValue() > (double)this.testValueRespLatency) {
                    if (sec - this.respLatencyExceededStart >= (long)this.testValueRespLatencySec) {
                        log.info("Average Latency Time is more than " + this.getResponseLatency() + " for " + this.getResponseLatencySecs() + "s. Auto-shutdown test...");
                        this.stopTest();
                    }
                } else {
                    this.respLatencyExceededStart = sec;
                }
            }
            if (this.testValueError > 0.0f) {
                if (this.errorRate.getValue() > (double)this.testValueError) {
                    if (sec - this.errRateExceededStart >= (long)this.testValueErrorSec) {
                        log.info("Error rate more than " + this.getErrorRate() + " for " + this.getErrorRateSecs() + "s. Auto-shutdown test...");
                        this.stopTest();
                    }
                } else {
                    this.errRateExceededStart = sec;
                }
            }
            this.curSec = sec;
            this.avgRespTime = new GraphPanelChartAverageElement();
            this.avgRespLatency = new GraphPanelChartAverageElement();
            this.errorRate = new GraphPanelChartAverageElement();
        }
        this.avgRespTime.add(se.getResult().getTime());
        this.avgRespLatency.add(se.getResult().getLatency());
        this.errorRate.add(se.getResult().isSuccessful() ? 0.0 : 1.0);
    }

    public void sampleStarted(SampleEvent se) {
    }

    public void sampleStopped(SampleEvent se) {
    }

    public void testStarted() {
        this.curSec = 0L;
        this.stopTries = 0;
        this.avgRespTime = new GraphPanelChartAverageElement();
        this.errorRate = new GraphPanelChartAverageElement();
        this.avgRespLatency = new GraphPanelChartAverageElement();
        this.errRateExceededStart = 0L;
        this.respTimeExceededStart = 0L;
        this.respLatencyExceededStart = 0L;
        this.testValueError = this.getErrorRateAsFloat();
        this.testValueErrorSec = this.getErrorRateSecsAsInt();
        this.testValueRespLatency = this.getResponseLatencyAsInt();
        this.testValueRespLatencySec = this.getResponseLatencySecsAsInt();
        this.testValueRespTime = this.getResponseTimeAsInt();
        this.testValueRespTimeSec = this.getResponseTimeSecsAsInt();
    }

    public void testStarted(String string) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String string) {
    }

    public void testIterationStart(LoopIterationEvent lie) {
    }

    void setResponseTime(String text) {
        this.setProperty(RESPONSE_TIME, text);
    }

    void setResponseLatency(String text) {
        this.setProperty(RESPONSE_LATENCY, text);
    }

    void setErrorRate(String text) {
        this.setProperty(ERROR_RATE, text);
    }

    void setResponseTimeSecs(String text) {
        this.setProperty(RESPONSE_TIME_SECS, text);
    }

    void setResponseLatencySecs(String text) {
        this.setProperty(RESPONSE_LATENCY_SECS, text);
    }

    void setErrorRateSecs(String text) {
        this.setProperty(ERROR_RATE_SECS, text);
    }

    String getResponseTime() {
        return this.getPropertyAsString(RESPONSE_TIME);
    }

    String getResponseTimeSecs() {
        return this.getPropertyAsString(RESPONSE_TIME_SECS);
    }

    String getResponseLatency() {
        return this.getPropertyAsString(RESPONSE_LATENCY);
    }

    String getResponseLatencySecs() {
        return this.getPropertyAsString(RESPONSE_LATENCY_SECS);
    }

    String getErrorRate() {
        return this.getPropertyAsString(ERROR_RATE);
    }

    String getErrorRateSecs() {
        return this.getPropertyAsString(ERROR_RATE_SECS);
    }

    private int getResponseTimeAsInt() {
        int res = 0;
        try {
            res = Integer.valueOf(this.getResponseTime());
        }
        catch (NumberFormatException e) {
            log.error("Wrong response time: " + this.getResponseTime(), (Throwable)e);
            this.setResponseTime("0");
        }
        return res;
    }

    private int getResponseTimeSecsAsInt() {
        int res = 0;
        try {
            res = Integer.valueOf(this.getResponseTimeSecs());
        }
        catch (NumberFormatException e) {
            log.error("Wrong response time period: " + this.getResponseTime(), (Throwable)e);
            this.setResponseTimeSecs("1");
        }
        return res > 0 ? res : 1;
    }

    private int getResponseLatencyAsInt() {
        int res = 0;
        try {
            res = Integer.valueOf(this.getResponseLatency());
        }
        catch (NumberFormatException e) {
            log.error("Wrong response time: " + this.getResponseLatency(), (Throwable)e);
            this.setResponseLatency("0");
        }
        return res;
    }

    private int getResponseLatencySecsAsInt() {
        int res = 0;
        try {
            res = Integer.valueOf(this.getResponseLatencySecs());
        }
        catch (NumberFormatException e) {
            log.error("Wrong response time period: " + this.getResponseLatencySecs(), (Throwable)e);
            this.setResponseLatencySecs("1");
        }
        return res > 0 ? res : 1;
    }

    private float getErrorRateAsFloat() {
        float res = 0.0f;
        try {
            res = Float.valueOf(this.getErrorRate()).floatValue() / 100.0f;
        }
        catch (NumberFormatException e) {
            log.error("Wrong error rate: " + this.getErrorRate(), (Throwable)e);
            this.setErrorRate("0");
        }
        return res;
    }

    private int getErrorRateSecsAsInt() {
        int res = 0;
        try {
            res = Integer.valueOf(this.getErrorRateSecs());
        }
        catch (NumberFormatException e) {
            log.error("Wrong error rate period: " + this.getResponseTime(), (Throwable)e);
            this.setErrorRateSecs("1");
        }
        return res > 0 ? res : 1;
    }

    private void stopTest() {
        ++this.stopTries;
        if (JMeter.isNonGUI()) {
            log.info("Stopping JMeter via UDP call");
            this.stopTestViaUDP("StopTestNow");
        } else if (this.stopTries > 10) {
            log.info("Tries more than 10, stop it NOW!");
            StandardJMeterEngine.stopEngineNow();
        } else if (this.stopTries > 5) {
            log.info("Tries more than 5, stop it!");
            StandardJMeterEngine.stopEngine();
        } else {
            JMeterContextService.getContext().getEngine().askThreadsToStop();
        }
    }

    private void stopTestViaUDP(String command) {
        try {
            int port = JMeterUtils.getPropDefault((String)"jmeterengine.nongui.port", (int)4445);
            log.info("Sending " + command + " request to port " + port);
            DatagramSocket socket = new DatagramSocket();
            byte[] buf = command.getBytes("ASCII");
            InetAddress address = InetAddress.getByName("localhost");
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, port);
            socket.send(packet);
            socket.close();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }
}

