/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.perfmon;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.perfmon.NewAgentConnector;
import kg.apc.jmeter.perfmon.OldAgentConnector;
import kg.apc.jmeter.perfmon.PerfMonAgentConnector;
import kg.apc.jmeter.perfmon.PerfMonSampleGenerator;
import kg.apc.jmeter.perfmon.PerfMonSampleResult;
import kg.apc.jmeter.perfmon.UnavailableAgentConnector;
import kg.apc.jmeter.reporters.LoadosophiaUploadingNotifier;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import kg.apc.perfmon.client.Transport;
import kg.apc.perfmon.client.TransportFactory;
import kg.apc.perfmon.metrics.MetricParams;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PerfMonCollector
extends CorrectedResultCollector
implements Runnable,
PerfMonSampleGenerator {
    private static boolean autoGenerateFiles = false;
    public static final long MEGABYTE = 0x100000L;
    private static final String PERFMON = "PerfMon";
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DATA_PROPERTY = "metricConnections";
    private int interval;
    private Thread workerThread = null;
    private Map<Object, PerfMonAgentConnector> connectors = new ConcurrentHashMap<Object, PerfMonAgentConnector>();
    private HashMap<String, Long> oldValues = new HashMap();
    private static String autoFileBaseName = null;
    private static int counter = 0;
    private LoadosophiaUploadingNotifier perfMonNotifier = LoadosophiaUploadingNotifier.getInstance();
    private static String workerHost = null;

    private static synchronized String getAutoFileName() {
        String ret = "";
        ++counter;
        if (autoFileBaseName == null) {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
            autoFileBaseName = "perfMon_" + formatter.format(now.getTime());
        }
        ret = ret + autoFileBaseName;
        if (counter > 1) {
            ret = ret + "_" + counter;
        }
        ret = ret + ".csv";
        return ret;
    }

    public PerfMonCollector() {
        this.interval = JMeterUtils.getPropDefault((String)"jmeterPlugin.perfmon.interval", (int)1000);
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public JMeterProperty getMetricSettings() {
        return this.getProperty(DATA_PROPERTY);
    }

    public void sampleOccurred(SampleEvent event) {
    }

    @Override
    public synchronized void run() {
        while (true) {
            this.processConnectors();
            try {
                this.wait(this.interval);
            }
            catch (InterruptedException ex) {
                log.debug("Monitoring thread was interrupted", (Throwable)ex);
                return;
            }
        }
    }

    private static synchronized boolean isWorkingHost(String host) {
        if (workerHost == null) {
            workerHost = host;
            return true;
        }
        return host.equals(workerHost);
    }

    public void testStarted(String host) {
        if (!PerfMonCollector.isWorkingHost(host)) {
            return;
        }
        if (this.getProperty("filename") == null || this.getProperty("filename").getStringValue().trim().length() == 0) {
            if (autoGenerateFiles) {
                this.setupSaving(PerfMonCollector.getAutoFileName());
            } else {
                try {
                    File tmpFile = File.createTempFile("perfmon_", ".jtl");
                    tmpFile.delete();
                    this.setupSaving(tmpFile.getAbsolutePath());
                }
                catch (IOException ex) {
                    log.info("PerfMon metrics will not be recorded! Please run the test with -JforcePerfmonFile=true", (Throwable)ex);
                }
            }
        }
        log.debug("PerfMon metrics will be stored in " + this.getPropertyAsString("filename"));
        if (!this.getSaveConfig().saveAsXml() && this.getSaveConfig().saveFieldNames()) {
            this.perfMonNotifier.addFile(this.getPropertyAsString("filename"));
        } else {
            log.warn("Perfmon file saving setting is not CSV with header line, cannot upload it to Loadosophia.org: " + this.getPropertyAsString("filename"));
        }
        this.initiateConnectors();
        this.workerThread = new Thread(this);
        this.workerThread.start();
        super.testStarted(host);
    }

    private void setupSaving(String fileName) {
        SampleSaveConfiguration config = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(config);
        this.setSaveConfig(config);
        this.setFilename(fileName);
        log.info("PerfMon metrics will be stored in " + new File(fileName).getAbsolutePath());
    }

    public void testEnded(String host) {
        if (this.workerThread == null) {
            return;
        }
        workerHost = null;
        this.workerThread.interrupt();
        this.shutdownConnectors();
        autoFileBaseName = null;
        counter = 0;
        super.testEnded(host);
    }

    private void initiateConnectors() {
        this.oldValues.clear();
        JMeterProperty prop = this.getMetricSettings();
        this.connectors.clear();
        if (!(prop instanceof CollectionProperty)) {
            log.warn("Got unexpected property: " + prop);
            return;
        }
        CollectionProperty rows = (CollectionProperty)prop;
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String host = ((JMeterProperty)row.get(0)).getStringValue();
            int port = ((JMeterProperty)row.get(1)).getIntValue();
            String metric = ((JMeterProperty)row.get(2)).getStringValue();
            String params = ((JMeterProperty)row.get(3)).getStringValue();
            this.initiateConnector(host, port, i, metric, params);
        }
        for (Object key : this.connectors.keySet()) {
            try {
                this.connectors.get(key).connect();
            }
            catch (IOException ex) {
                log.error("Error connecting to agent", (Throwable)ex);
                this.connectors.put(key, new UnavailableAgentConnector(ex));
            }
        }
    }

    private void initiateConnector(String host, int port, int index, String metric, String params) {
        String label;
        InetSocketAddress addr = new InetSocketAddress(host, port);
        String stringKey = addr.toString() + "#" + index;
        MetricParams paramsParsed = MetricParams.createFromString((String)params);
        if (paramsParsed.getLabel().isEmpty()) {
            label = host + " " + metric;
            if (params != null && !params.isEmpty()) {
                label = label + " " + params;
            }
        } else {
            label = host + " " + metric + " " + paramsParsed.getLabel();
            String[] tokens = params.split("(?<!\\\\):");
            params = "";
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].startsWith("label=")) continue;
                if (params.length() != 0) {
                    params = params + ":";
                }
                params = params + tokens[i];
            }
        }
        try {
            if (this.connectors.containsKey(addr)) {
                this.connectors.get(addr).addMetric(metric, params, label);
            } else {
                PerfMonAgentConnector connector = this.getConnector(host, port);
                connector.addMetric(metric, params, label);
                if (connector instanceof OldAgentConnector) {
                    this.connectors.put(stringKey, connector);
                } else {
                    this.connectors.put(addr, connector);
                }
            }
        }
        catch (IOException e) {
            log.error("Problems creating connector", (Throwable)e);
            this.connectors.put(stringKey, new UnavailableAgentConnector(e));
        }
    }

    protected PerfMonAgentConnector getConnector(String host, int port) throws IOException {
        try {
            log.debug("Trying new connector");
            Transport transport = TransportFactory.getTransport((SocketAddress)new InetSocketAddress(host, port));
            NewAgentConnector conn = new NewAgentConnector();
            conn.setTransport(transport);
            return conn;
        }
        catch (IOException e) {
            log.debug("Using old connector");
            return new OldAgentConnector(host, port);
        }
    }

    private void shutdownConnectors() {
        log.debug("Shutting down connectors");
        Iterator<Object> it = this.connectors.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            PerfMonAgentConnector conn = this.connectors.get(key);
            log.debug("Shutting down " + conn.toString());
            it.remove();
            conn.disconnect();
        }
    }

    private void processConnectors() {
        for (Object key : this.connectors.keySet()) {
            PerfMonAgentConnector connector = this.connectors.get(key);
            try {
                connector.generateSamples(this);
            }
            catch (IOException e) {
                log.error(e.getMessage());
                this.connectors.put(key, new UnavailableAgentConnector(e));
            }
        }
    }

    @Override
    public void generateSample(double value, String label) {
        if (value != -2.0) {
            PerfMonSampleResult res = new PerfMonSampleResult();
            res.setSampleLabel(label);
            res.setValue(value);
            res.setSuccessful(true);
            SampleEvent e = new SampleEvent((SampleResult)res, PERFMON);
            super.sampleOccurred(e);
        }
    }

    @Override
    public void generateErrorSample(String label, String errorMsg) {
        PerfMonSampleResult res = new PerfMonSampleResult();
        res.setSampleLabel(label);
        res.setValue(-1.0);
        res.setResponseMessage(errorMsg);
        res.setSuccessful(false);
        SampleEvent e = new SampleEvent((SampleResult)res, PERFMON);
        super.sampleOccurred(e);
        log.error("Perfmon plugin error: " + errorMsg);
    }

    @Override
    public void generate2Samples(long[] values, String label1, String label2) {
        this.generate2Samples(values, label1, label2, 1.0);
    }

    @Override
    public void generate2Samples(long[] values, String label1, String label2, double dividingFactor) {
        if (this.oldValues.containsKey(label1) && this.oldValues.containsKey(label2)) {
            this.generateSample((double)(values[0] - this.oldValues.get(label1)) / dividingFactor, label1);
            this.generateSample((double)(values[1] - this.oldValues.get(label2)) / dividingFactor, label2);
        }
        this.oldValues.put(label1, new Long(values[0]));
        this.oldValues.put(label2, new Long(values[1]));
    }

    static {
        autoGenerateFiles = JMeterUtils.getPropDefault((String)"forcePerfmonFile", (String)"false").trim().equalsIgnoreCase("true");
    }
}

