/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import kg.apc.jmeter.modifiers.FifoMap;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class FifoPopPreProcessor
extends AbstractTestElement
implements PreProcessor,
TestListener {
    public static final String queueName = "FifoName";
    public static final String variableName = "Variable";
    public static final String TIMEOUT = "Timeout";

    public FifoPopPreProcessor() {
        this.setTimeout(Long.toString(JMeterUtils.getPropDefault((String)"kg.apc.jmeter.functions.FifoTimeout", (long)Long.MAX_VALUE)));
    }

    public void testStarted() {
        FifoMap.getInstance().clear();
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
        FifoMap.getInstance().clear();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    public void process() {
        String value;
        try {
            value = FifoMap.getInstance().pop(this.getQueueName(), this.getTimeoutAsLong());
        }
        catch (InterruptedException ex) {
            value = "INTERRUPTED";
        }
        JMeterVariables vars = JMeterContextService.getContext().getVariables();
        if (vars != null) {
            vars.put(this.getVarName(), value);
        }
    }

    public String getVarName() {
        return this.getPropertyAsString(variableName);
    }

    private long getTimeoutAsLong() {
        return Long.parseLong(this.getTimeout());
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT);
    }

    public String getQueueName() {
        return this.getPropertyAsString(queueName);
    }

    public final void setTimeout(String atimeout) {
        this.setProperty(TIMEOUT, atimeout);
    }

    public void setVarName(String text) {
        this.setProperty(variableName, text);
    }

    public void setQueueName(String text) {
        this.setProperty(queueName, text);
    }
}

