/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.modifiers;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.RuntimeEOFException;
import kg.apc.jmeter.modifiers.RawRequestSourcePreProcessor;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CheckConsistencyAction
implements ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final JTextField filename;
    private final JTextArea infoArea;

    public CheckConsistencyAction(JTextField field, JTextArea checkInfo) {
        this.filename = field;
        this.infoArea = checkInfo;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.infoArea.setText("");
        this.infoArea.setForeground(Color.black);
        String fname = this.filename.getText();
        File f = new File(fname);
        if (!f.exists()) {
            this.reportError("File '" + fname + "' was not found");
            return;
        }
        int cnt = 0;
        try {
            RawRequestSourcePreProcessor preproc = new RawRequestSourcePreProcessor();
            preproc.testStarted();
            preproc.setFileName(fname);
            preproc.setVarName("test");
            preproc.setRewindOnEOF(false);
            while (true) {
                preproc.process();
                ++cnt;
            }
        }
        catch (RuntimeEOFException ex) {
            this.reportOk("File seems to be OK.");
            this.infoArea.setForeground(Color.decode("0x00009900"));
        }
        catch (RuntimeException ex) {
            log.debug("Runtime Exception", (Throwable)ex);
            this.reportError(ex.toString() + " " + JMeterPluginsUtils.getStackTrace(ex));
        }
        this.reportOk("Parsed " + cnt + " requests in " + fname);
    }

    private void reportError(String msg) {
        this.infoArea.setText(this.infoArea.getText() + "File inconsistency: " + msg + "\n");
        this.infoArea.setForeground(Color.red);
    }

    private void reportOk(String string) {
        this.infoArea.setText(this.infoArea.getText() + string + "\n");
    }
}

