/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dbmon;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.dbmon.DbMonSampleGenerator;
import kg.apc.jmeter.dbmon.DbMonSampleResult;
import kg.apc.jmeter.dbmon.DbMonSampler;
import kg.apc.jmeter.vizualizers.CorrectedResultCollector;
import org.apache.jmeter.protocol.jdbc.config.DataSourceElement;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DbMonCollector
extends CorrectedResultCollector
implements Runnable,
DbMonSampleGenerator {
    private static boolean autoGenerateFiles = false;
    private static final String DBMON = "DbMon";
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String DATA_PROPERTY = "samplers";
    private int interval;
    private Thread workerThread = null;
    private List<DbMonSampler> dbMonSamplers = new ArrayList<DbMonSampler>();
    private static String autoFileBaseName = null;
    private static int counter = 0;
    private static String workerHost = null;

    private static synchronized String getAutoFileName() {
        String ret = "";
        ++counter;
        if (autoFileBaseName == null) {
            Calendar now = Calendar.getInstance();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd-HHmmss");
            autoFileBaseName = "dbMon_" + formatter.format(now.getTime());
        }
        ret = ret + autoFileBaseName;
        if (counter > 1) {
            ret = ret + "_" + counter;
        }
        ret = ret + ".csv";
        return ret;
    }

    public DbMonCollector() {
        this.interval = JMeterUtils.getPropDefault((String)"jmeterPlugin.dbmon.interval", (int)1000);
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    public JMeterProperty getSamplerSettings() {
        return this.getProperty(DATA_PROPERTY);
    }

    @Override
    public synchronized void run() {
        try {
            while (true) {
                this.processConnectors();
                this.wait(this.interval);
            }
        }
        catch (InterruptedException ex) {
            log.debug("Monitoring thread was interrupted", (Throwable)ex);
            return;
        }
    }

    private static synchronized boolean isWorkingHost(String host) {
        if (workerHost == null) {
            workerHost = host;
            return true;
        }
        return host.equals(workerHost);
    }

    public void testStarted(String host) {
        if (!DbMonCollector.isWorkingHost(host)) {
            return;
        }
        if (this.getProperty("filename") == null || this.getProperty("filename").getStringValue().trim().length() == 0) {
            if (autoGenerateFiles) {
                this.setupSaving(DbMonCollector.getAutoFileName());
            } else {
                log.info("DbMon metrics will not be recorded! Please specify a file name in the gui or run the test with -JforceDbmonFile=true");
            }
        }
        try {
            this.initiateConnectors();
        }
        catch (SQLException ex) {
            log.error("Enable to start dbmon", (Throwable)ex);
        }
        this.workerThread = new Thread(this);
        this.workerThread.start();
        super.testStarted(host);
    }

    private void setupSaving(String fileName) {
        SampleSaveConfiguration config = this.getSaveConfig();
        JMeterPluginsUtils.doBestCSVSetup(config);
        this.setSaveConfig(config);
        this.setFilename(fileName);
        log.info("DbMon metrics will be stored in " + new File(fileName).getAbsolutePath());
    }

    public void testEnded(String host) {
        if (this.workerThread == null) {
            return;
        }
        workerHost = null;
        this.workerThread.interrupt();
        this.shutdownConnectors();
        autoFileBaseName = null;
        counter = 0;
        super.testEnded(host);
    }

    private void initiateConnectors() throws SQLException {
        JMeterProperty prop = this.getSamplerSettings();
        this.dbMonSamplers.clear();
        if (!(prop instanceof CollectionProperty)) {
            log.warn("Got unexpected property: " + prop);
            return;
        }
        CollectionProperty rows = (CollectionProperty)prop;
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String connectionPool = ((JMeterProperty)row.get(0)).getStringValue();
            Connection conn = DataSourceElement.getConnection((String)connectionPool);
            String label = ((JMeterProperty)row.get(1)).getStringValue();
            boolean isDelta = ((JMeterProperty)row.get(2)).getBooleanValue();
            String sql = ((JMeterProperty)row.get(3)).getStringValue();
            this.initiateConnector(conn, label, isDelta, sql);
        }
    }

    private void initiateConnector(Connection conn, String name, boolean delta, String sql) {
        this.dbMonSamplers.add(new DbMonSampler(conn, name, delta, sql));
    }

    private void shutdownConnectors() {
        this.dbMonSamplers.clear();
    }

    protected void processConnectors() {
        for (DbMonSampler sampler : this.dbMonSamplers) {
            sampler.generateSamples(this);
        }
    }

    public void sampleOccurred(SampleEvent event) {
    }

    protected void dbMonSampleOccurred(SampleEvent event) {
        super.sampleOccurred(event);
    }

    @Override
    public void generateSample(double value, String label) {
        DbMonSampleResult res = new DbMonSampleResult();
        res.setSampleLabel(label);
        res.setValue(value);
        res.setSuccessful(true);
        SampleEvent e = new SampleEvent((SampleResult)res, DBMON);
        this.dbMonSampleOccurred(e);
    }

    static {
        autoGenerateFiles = JMeterUtils.getPropDefault((String)"forceDbmonFile", (String)"false").trim().equalsIgnoreCase("true");
    }
}

