/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.util.Map;
import kg.apc.jmeter.config.VariableFromCsvFileReader;
import org.apache.jmeter.config.Arguments;

public class VariablesFromCSV
extends Arguments {
    public static final String VARIABLE_PREFIX = "variablesPrefix";
    public static final String FILENAME = "filename";
    public static final String SEPARATOR = "delimiter";
    public static final String STORE_SYS_PROP = "storeSysProp";

    public Map<String, String> getArgumentsAsMap() {
        Map<String, String> variables = new VariableFromCsvFileReader(this.getFileName()).getDataAsMap(this.getVariablePrefix(), this.getSeparator());
        if (this.isStoreAsSystemProperty()) {
            for (String variable : variables.keySet()) {
                if (System.getProperty(variable) != null) continue;
                System.setProperty(variable, variables.get(variable));
            }
        }
        return variables;
    }

    public String getVariablePrefix() {
        return this.getPropertyAsString(VARIABLE_PREFIX);
    }

    public void setVariablePrefix(String prefix) {
        this.setProperty(VARIABLE_PREFIX, prefix);
    }

    public String getFileName() {
        return this.getPropertyAsString(FILENAME);
    }

    public void setFileName(String filename) {
        this.setProperty(FILENAME, filename);
    }

    public String getSeparator() {
        return this.getPropertyAsString(SEPARATOR);
    }

    public void setSeparator(String separator) {
        this.setProperty(SEPARATOR, separator);
    }

    public boolean isStoreAsSystemProperty() {
        return this.getPropertyAsBoolean(STORE_SYS_PROP);
    }

    public void setStoreAsSystemProperty(boolean storeAsSysProp) {
        this.setProperty(STORE_SYS_PROP, storeAsSysProp);
    }
}

