/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.config;

import java.io.File;
import java.io.IOException;
import kg.apc.io.FileSystem;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopTestNowException;
import org.apache.log.Logger;

public class LockFile
extends ConfigTestElement
implements TestListener {
    public static Logger log = LoggingManager.getLoggerForClass();
    public static final String FILENAME = "filename";
    public static final String FILEMASK = "filemask";

    public void testStarted() {
        this.testStarted(null);
    }

    public void testStarted(String string) {
        log.debug("[LockFile plugin] Test started captured");
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            String path;
            log.info("[LockFile plugin] Checking lockfile at " + this.getFilename());
            File file = new File(this.getFilename());
            try {
                path = file.getParentFile() != null ? file.getParentFile().getCanonicalPath() : new File(".").getCanonicalPath();
            }
            catch (IOException ex) {
                log.error("[LockFile plugin] Failed to get path");
                throw new JMeterStopTestNowException("[LockFile plugin] Failed to get path");
            }
            log.info("[LockFile plugin] and by wildcard at " + path + this.getFilemask());
            if (file.exists()) {
                log.error("[LockFile plugin] Lock file found: " + this.getFilename());
                throw new JMeterStopTestNowException("[LockFile plugin] Lock file found: " + this.getFilename());
            }
            if (this.getFilemask() != null && this.getFilemask().length() > 0 && FileSystem.checkFileExistByPattern(path, this.getFilemask())) {
                log.error("[LockFile plugin] Lock file found by pattern " + this.getFilemask());
                throw new JMeterStopTestNowException("[LockFile plugin] Lock file found by pattern " + this.getFilemask());
            }
            try {
                log.info("[LockFile plugin] Create lockfile at " + this.getFilename());
                file.createNewFile();
            }
            catch (IOException e) {
                log.error("[LockFile plugin] Could not create lock file: " + e.getLocalizedMessage());
                throw new JMeterStopTestNowException("[LockFile plugin] Could not create lock file: " + e.getLocalizedMessage());
            }
        }
        log.debug("[Lockfile plugin] Filename: " + this.getFilename());
        log.warn("[Lockfile plugin] No lockfile set. Ignore.");
    }

    public void testEnded() {
        this.testEnded(null);
    }

    public void testEnded(String string) {
        File file;
        log.debug("[LockFile plugin] Test ended captured");
        if (this.getFilename() != null && this.getFilename().length() > 0 && (file = new File(this.getFilename())).exists()) {
            log.info("[LockFile plugin] Remove lockfile from " + this.getFilename());
            file.delete();
        }
    }

    public void testIterationStart(LoopIterationEvent lie) {
    }

    public String getFilename() {
        log.debug("[LockFile plugin] Return filename: " + this.getPropertyAsString(FILENAME));
        return this.getPropertyAsString(FILENAME);
    }

    public void setFilename(String filename) {
        log.debug("[LockFile plugin] Set filename to: " + filename);
        this.setProperty(FILENAME, filename);
    }

    public String getFilemask() {
        log.debug("[LockFile plugin] Return filemask: " + this.getPropertyAsString(FILEMASK));
        return this.getPropertyAsString(FILEMASK);
    }

    public void setFilemask(String filemask) {
        log.debug("[LockFile plugin] Set filemask to: " + filemask);
        this.setProperty(FILEMASK, filemask);
    }
}

