/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.oauth;

import com.atlantbh.jmeter.plugins.oauth.OAuthGenerator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSampler2;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class OAuthSampler
extends HTTPSampler2 {
    private static final long serialVersionUID = -5877623539165274730L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String CONSUMER_KEY = "OAuthSampler.consumer_key";
    public static final String CONSUMER_SECRET = "OAuthSampler.consumer_secret";
    public static final String REQUEST_BODY = "OAuthSampler.request_body";
    public static final String PORT_NUMBER = "OAuthSampler.port_number";
    public static final String RESOURCE = "OAuthSampler.resource";
    public static final String BASE_HOST = "OAuthSampler.base_host";
    public static final String REQUEST_HEADERS = "OAuthSampler.request_headers";

    public void setConsumerKey(String consumerKey) {
        this.setProperty(CONSUMER_KEY, consumerKey);
    }

    public void setConsumerSecret(String consumerSecret) {
        this.setProperty(CONSUMER_SECRET, consumerSecret);
    }

    public String getConsumerKey() {
        return this.getPropertyAsString(CONSUMER_KEY);
    }

    public String getConsumerSecret() {
        return this.getPropertyAsString(CONSUMER_SECRET);
    }

    public void setRequestBody(String data) {
        this.setProperty(REQUEST_BODY, data);
    }

    public void setRequestHeaders(String headers) {
        this.setProperty(REQUEST_HEADERS, headers);
    }

    public String getRequestBody() {
        return this.getPropertyAsString(REQUEST_BODY);
    }

    public String getRequestHeaders() {
        return this.getPropertyAsString(REQUEST_HEADERS);
    }

    public void setResource(String data) {
        this.setProperty(RESOURCE, data);
    }

    public String getResource() {
        return this.getPropertyAsString(RESOURCE);
    }

    public void setPortNumber(String data) {
        this.setProperty(PORT_NUMBER, data);
    }

    public String getPortNumber() {
        return this.getPropertyAsString(PORT_NUMBER);
    }

    public void setHostBaseUrl(String data) {
        this.setProperty(BASE_HOST, data);
    }

    public String getHostBaseUrl() {
        return this.getPropertyAsString(BASE_HOST);
    }

    public URL getUrl() throws MalformedURLException {
        String validHost = this.toValidUrl(this.getHostBaseUrl());
        URL u = null;
        if (validHost != null && this.getResource() != null) {
            String fullUrl = validHost + (this.getPortNumber() == null || this.getPortNumber().length() == 0 ? "" : ":" + this.getPortNumber()) + "/" + this.getResource();
            u = this.toURL(fullUrl);
        }
        return u;
    }

    private String toValidUrl(String u) throws MalformedURLException {
        URL url = new URL(u);
        String urlStr = url.toString();
        if (urlStr.endsWith("/")) {
            url = this.toURL(urlStr.substring(0, urlStr.length() - 1));
            urlStr = url.toString();
        }
        return urlStr;
    }

    private URL toURL(String u) {
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private void overrideHeaders(HttpMethodBase httpMethod, String url, String method) {
        String[] header;
        String headers = this.getRequestHeaders();
        for (String kvp : header = headers.split(System.getProperty("line.separator"))) {
            int pos = kvp.indexOf(58);
            if (pos < 0) {
                pos = kvp.indexOf(61);
            }
            if (pos <= 0) continue;
            String k = kvp.substring(0, pos).trim();
            String v = "";
            if (kvp.length() > pos + 1) {
                v = kvp.substring(pos + 1).trim();
            }
            httpMethod.addRequestHeader(k, v);
        }
        String authorization = OAuthGenerator.getInstance(this.getConsumerKey(), this.getConsumerSecret()).getAuthorization(url, method);
        httpMethod.addRequestHeader("Authorization", authorization);
    }

    protected HttpClient setupConnection(URL u, HttpMethodBase httpMethod) throws IOException {
        HTTPSampleResult temp = new HTTPSampleResult();
        return super.setupConnection(u, httpMethod, temp);
    }

    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        throw new RuntimeException("Should never be called");
    }

    /*
     * Exception decompiling
     */
    public SampleResult sample() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setDefaultRequestHeaders(HttpMethodBase httpMethod) {
    }

    private HttpMethodBase createHttpMethod(String method, String urlStr) {
        PostMethod httpMethod;
        if (method.equals("POST")) {
            httpMethod = new PostMethod(urlStr);
        } else if (method.equals("PUT")) {
            httpMethod = new PutMethod(urlStr);
        } else if (method.equals("HEAD")) {
            httpMethod = new HeadMethod(urlStr);
        } else if (method.equals("TRACE")) {
            httpMethod = new TraceMethod(urlStr);
        } else if (method.equals("OPTIONS")) {
            httpMethod = new OptionsMethod(urlStr);
        } else if (method.equals("DELETE")) {
            httpMethod = new DeleteMethod(urlStr);
        } else if (method.equals("GET")) {
            httpMethod = new GetMethod(urlStr);
        } else {
            log.error("Unexpected method (converted to GET): " + method);
            httpMethod = new GetMethod(urlStr);
        }
        return httpMethod;
    }
}

