/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.gui;

import com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor.JSONPathExtractor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class JSONPathExtractorGui
extends AbstractPostProcessorGui {
    private static final long serialVersionUID = 1L;
    private JLabeledTextField jsonExtractValueTextField = null;
    private JLabeledTextField jsonPathTextField = null;

    public JSONPathExtractorGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        this.jsonExtractValueTextField = new JLabeledTextField("Name: ");
        this.jsonPathTextField = new JLabeledTextField("JSON path: ");
        panel.add((Component)this.jsonExtractValueTextField);
        panel.add((Component)this.jsonPathTextField);
        this.add((Component)panel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.jsonExtractValueTextField.setText("");
        this.jsonPathTextField.setText("");
    }

    public TestElement createTestElement() {
        JSONPathExtractor extractor = new JSONPathExtractor();
        this.modifyTestElement((TestElement)extractor);
        return extractor;
    }

    public String getLabelResource() {
        return "JSON Path Extractor";
    }

    public String getStaticLabel() {
        return "JSON Path Extractor";
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathExtractor) {
            JSONPathExtractor extractor = (JSONPathExtractor)element;
            extractor.setVar(this.jsonExtractValueTextField.getText());
            extractor.setJsonPath(this.jsonPathTextField.getText());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JSONPathExtractor) {
            JSONPathExtractor extractor = (JSONPathExtractor)element;
            this.jsonExtractValueTextField.setText(extractor.getVar());
            this.jsonPathTextField.setText(extractor.getJsonPath());
        }
    }
}

