/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import java.text.ParseException;
import java.util.List;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;

public class JSONPathExtractor
extends AbstractTestElement
implements PostProcessor {
    private static final long serialVersionUID = 1L;
    private static final String JSONPATH = "JSONPATH";
    private static final String VAR = "VAR";

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getVar() {
        return this.getPropertyAsString(VAR);
    }

    public void setVar(String var) {
        this.setProperty(VAR, var);
    }

    public String extractJSONPath(String jsonString, String jsonPath) throws Exception {
        Object jsonPathResult = JsonPath.read((String)jsonString, (String)jsonPath, (Filter[])new Filter[0]);
        if (null == jsonPathResult) {
            throw new Exception("Invalid JSON path provided!");
        }
        if (jsonPathResult instanceof List && ((List)jsonPathResult).isEmpty()) {
            return "NULL";
        }
        return jsonPathResult.toString();
    }

    public void process() {
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        JMeterVariables vars = context.getVariables();
        String responseData = context.getPreviousResult().getResponseDataAsString();
        try {
            String response = this.extractJSONPath(responseData, this.getJsonPath());
            vars.put(this.getVar(), response);
        }
        catch (InvalidPathException e) {
            System.out.println("Extract failed!. Invalid JSON path: " + e.getMessage());
        }
        catch (ParseException e) {
            System.out.println("Extract failed!. Invalid JSON path: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

