/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion.gui;

import com.atlantbh.jmeter.plugins.jsonutils.jsonpathassertion.JSONPathAssertion;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class JSONPathAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 1L;
    private JLabeledTextField jsonPath = null;
    private JLabeledTextField jsonValue = null;
    private JCheckBox jsonValidation = null;

    public JSONPathAssertionGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "JSON path assertion"));
        this.jsonPath = new JLabeledTextField("JSON path: ");
        this.jsonValue = new JLabeledTextField("Expected value: ");
        this.jsonValidation = new JCheckBox("Validate against expected value");
        panel.add((Component)this.jsonPath);
        panel.add((Component)this.jsonValue);
        panel.add((Component)this.jsonValidation);
        this.add((Component)panel, "Center");
    }

    public void clearGui() {
        super.clearGui();
        this.jsonPath.setText("");
        this.jsonValue.setText("");
        this.jsonValidation.setSelected(false);
    }

    public TestElement createTestElement() {
        JSONPathAssertion jpAssertion = new JSONPathAssertion();
        this.modifyTestElement((TestElement)jpAssertion);
        return jpAssertion;
    }

    public String getLabelResource() {
        return "JSON Path Assertion";
    }

    public String getStaticLabel() {
        return "JSON Path Assertion";
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            jpAssertion.setJsonPath(this.jsonPath.getText());
            jpAssertion.setExpectedValue(this.jsonValue.getText());
            jpAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
        this.jsonPath.setText(jpAssertion.getJsonPath());
        this.jsonValue.setText(jpAssertion.getExpectedValue());
        this.jsonValidation.setSelected(jpAssertion.isJsonValidationBool());
    }
}

