/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecrud;

import com.atlantbh.jmeter.plugins.hbasecrud.HbaseCrudHelper;
import java.io.IOException;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;

public class HbaseCrud
extends AbstractSampler {
    private static final long serialVersionUID = 1L;
    private static final String HBASEZOOKEEPERQUORUM = "HBASEZOOKEEPERQUORUM";
    private static final String HBASESOURCETABLE = "HBASESOURCETABLE";
    private static final String ROWKEY = "ROWKEY";
    private static final String COLUMNFAMILYCOLUMNNAMELIST = "COLUMNFAMILYCOLUMNNAMELIST";
    private static final String FULLCOLUMNNAMESLIST = "FULLCOLUMNNAMESLIST";
    private static final String FILTERCOLUMNFAMILIESFORTIMESTAMP = "FILTERCOLUMNSFORTIMESTAMP";
    private static final String ADDORUPDATEDATAONRECORDBOOL = "ADDORUPDATEDATAONRECORDBOOL";
    private static final String DELETEDATAFROMRECORDBOOL = "DELETEDATAFROMRECORDBOOL";
    private static final String LATESTTIMESTAMPOPERATIONBOOL = "LATESTTIMESTAMPOPERATIONBOOL";
    private static final String LATESTTIMESTAMPOPERATIONWITHFILTERBOOL = "LATESTTIMESTAMPOPERATIONWITHFILTERBOOL";

    public void setHbaseZookeeperQuorum(String hbaseZookeeperQuorum) {
        this.setProperty(HBASEZOOKEEPERQUORUM, hbaseZookeeperQuorum);
    }

    public String getHbaseZookeeperQuorum() {
        return this.getPropertyAsString(HBASEZOOKEEPERQUORUM);
    }

    public void setHbaseSourceTable(String hbaseSourceTable) {
        this.setProperty(HBASESOURCETABLE, hbaseSourceTable);
    }

    public String getHbaseSourceTable() {
        return this.getPropertyAsString(HBASESOURCETABLE);
    }

    public void setRowKey(String rowKey) {
        this.setProperty(ROWKEY, rowKey);
    }

    public String getRowKey() {
        return this.getPropertyAsString(ROWKEY);
    }

    public void setFullColumnNamesList(String fullColumnNamesList) {
        this.setProperty(FULLCOLUMNNAMESLIST, fullColumnNamesList);
    }

    public String getFullColumnNamesList() {
        return this.getPropertyAsString(FULLCOLUMNNAMESLIST);
    }

    public void setColumnFamilyColumnNameList(String columnFamilyColumnNameList) {
        this.setProperty(COLUMNFAMILYCOLUMNNAMELIST, columnFamilyColumnNameList);
    }

    public String getColumnFamilyColumnNameList() {
        return this.getPropertyAsString(COLUMNFAMILYCOLUMNNAMELIST);
    }

    public void setFilterColumnFamiliesForTimestamp(String filterColumnFamiliesForTimestamp) {
        this.setProperty(FILTERCOLUMNFAMILIESFORTIMESTAMP, filterColumnFamiliesForTimestamp);
    }

    public String getFilterColumnFamiliesForTimestamp() {
        return this.getPropertyAsString(FILTERCOLUMNFAMILIESFORTIMESTAMP);
    }

    public void setAddOrUpdateDataOnRecordBool(boolean addOrUpdateDataOnRecord) {
        this.setProperty(ADDORUPDATEDATAONRECORDBOOL, addOrUpdateDataOnRecord);
    }

    public boolean isAddOrUpdateDataOnRecordBool() {
        return this.getPropertyAsBoolean(ADDORUPDATEDATAONRECORDBOOL);
    }

    public void setDeleteDataFromRecordBool(boolean deleteDataFromRecord) {
        this.setProperty(DELETEDATAFROMRECORDBOOL, deleteDataFromRecord);
    }

    public boolean isDeleteDataFromRecordBool() {
        return this.getPropertyAsBoolean(DELETEDATAFROMRECORDBOOL);
    }

    public void setLatestTimestampOperationBool(boolean latestTimestampOperation) {
        this.setProperty(LATESTTIMESTAMPOPERATIONBOOL, latestTimestampOperation);
    }

    public boolean isLatestTimestampOperationBool() {
        return this.getPropertyAsBoolean(LATESTTIMESTAMPOPERATIONBOOL);
    }

    public void setLatestTimestampOperationWithFilterBool(boolean latestTimestampOperationWithFilter) {
        this.setProperty(LATESTTIMESTAMPOPERATIONWITHFILTERBOOL, latestTimestampOperationWithFilter);
    }

    public boolean isLatestTimestampOperationWithFilterBool() {
        return this.getPropertyAsBoolean(LATESTTIMESTAMPOPERATIONWITHFILTERBOOL);
    }

    public SampleResult sample(Entry arg0) {
        SampleResult result = new SampleResult();
        String requestData = "hbase.zookeeper.quorum: " + this.getHbaseZookeeperQuorum() + "\n";
        requestData = requestData + "HBase source table: " + this.getHbaseSourceTable() + "\n";
        requestData = requestData + "Rowkey: " + this.getRowKey() + "\n";
        requestData = requestData + "Attributes specified: \n";
        if (!"".equals(this.getFullColumnNamesList())) {
            String[] fullColumnNamesList;
            for (String fullColumnName : fullColumnNamesList = this.getFullColumnNamesList().split(",")) {
                requestData = requestData + "Full column name: " + fullColumnName + "\n";
            }
        }
        if (!"".equals(this.getColumnFamilyColumnNameList())) {
            String[] columnFamilyColumnNameList;
            for (String columnFamilyColumnName : columnFamilyColumnNameList = this.getColumnFamilyColumnNameList().split(",")) {
                requestData = requestData + "Column family column name: " + columnFamilyColumnName + "\n";
            }
        }
        String response = "";
        result.setSampleLabel(this.getName());
        result.setSamplerData(requestData);
        result.setDataType("text");
        result.sampleStart();
        HbaseCrudHelper hbaseCrudHelper = new HbaseCrudHelper();
        try {
            hbaseCrudHelper.setConfiguration(this.getHbaseZookeeperQuorum(), this.getHbaseSourceTable());
        }
        catch (IOException ex) {
            result.setResponseData(ex.getMessage().getBytes());
            result.setSuccessful(false);
            return result;
        }
        catch (Exception ex) {
            result.setResponseData(ex.getMessage().getBytes());
            result.setSuccessful(false);
            return result;
        }
        if (this.isAddOrUpdateDataOnRecordBool()) {
            if (this.isLatestTimestampOperationBool()) {
                try {
                    hbaseCrudHelper.addOrUpdateDataToHBase(this.getRowKey(), this.getFullColumnNamesList());
                    response = hbaseCrudHelper.getResponseMessage();
                    result.setResponseData(response.getBytes());
                    result.setSuccessful(true);
                }
                catch (IOException ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
                catch (Exception ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
            }
            if (this.isLatestTimestampOperationWithFilterBool()) {
                try {
                    hbaseCrudHelper.parseColumnFamilies(this.getFilterColumnFamiliesForTimestamp());
                    hbaseCrudHelper.addOrUpdateDataToHBase(this.getRowKey(), this.getFullColumnNamesList());
                    response = hbaseCrudHelper.getResponseMessage();
                    result.setResponseData(response.getBytes());
                    result.setSuccessful(true);
                }
                catch (IOException ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
                catch (Exception ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
            }
        }
        if (this.isDeleteDataFromRecordBool()) {
            if (this.isLatestTimestampOperationBool()) {
                try {
                    hbaseCrudHelper.deleteDataFromHbase(this.getRowKey(), this.getColumnFamilyColumnNameList());
                    response = hbaseCrudHelper.getResponseMessage();
                    result.setResponseData(response.getBytes());
                    result.setSuccessful(true);
                }
                catch (IOException ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
                catch (Exception ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
            }
            if (this.isLatestTimestampOperationWithFilterBool()) {
                try {
                    hbaseCrudHelper.parseColumnFamilies(this.getFilterColumnFamiliesForTimestamp());
                    hbaseCrudHelper.deleteDataFromHbase(this.getRowKey(), this.getColumnFamilyColumnNameList());
                    response = hbaseCrudHelper.getResponseMessage();
                    result.setResponseData(response.getBytes());
                    result.setSuccessful(true);
                }
                catch (IOException ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
                catch (Exception ex) {
                    result.setResponseData(ex.getMessage().getBytes());
                    result.setSuccessful(false);
                }
            }
        }
        return result;
    }
}

