/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter;

import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.ExpressionNode;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.FilterParser;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.Node;
import com.atlantbh.jmeter.plugins.hbasecomponents.utils.filter.OperatorNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class HBaseFilterParser {
    private static final Map<String, CompareFilter.CompareOp> OPERATOR_MAPINGS = new HashMap<String, CompareFilter.CompareOp>();

    public static Filter parse(Node node) throws Exception {
        if (node instanceof OperatorNode) {
            OperatorNode operator = (OperatorNode)node;
            FilterList filter = null;
            String op = null;
            op = operator.getOperators().isEmpty() ? " AND ".trim() : operator.getOperators().iterator().next();
            filter = " AND ".trim().equals(op) ? new FilterList(FilterList.Operator.MUST_PASS_ALL) : new FilterList(FilterList.Operator.MUST_PASS_ONE);
            for (Node child : operator.getChilds()) {
                filter.addFilter(HBaseFilterParser.parse(child));
            }
            return filter;
        }
        if (node instanceof ExpressionNode) {
            ExpressionNode expressionNode = (ExpressionNode)node;
            byte[] value = null;
            value = expressionNode.getValue() == null ? new byte[]{} : Bytes.toBytes((String)expressionNode.getValue());
            SingleColumnValueFilter singleColumnValueFilter = new SingleColumnValueFilter(Bytes.toBytes((String)expressionNode.getColumnFamily()), Bytes.toBytes((String)expressionNode.getQualifier()), OPERATOR_MAPINGS.get(expressionNode.getOper()), value);
            singleColumnValueFilter.setFilterIfMissing(true);
            return singleColumnValueFilter;
        }
        return null;
    }

    static {
        OPERATOR_MAPINGS.put(FilterParser.COMPARE_OPERATORS[0], CompareFilter.CompareOp.EQUAL);
        OPERATOR_MAPINGS.put(FilterParser.COMPARE_OPERATORS[1], CompareFilter.CompareOp.NOT_EQUAL);
        OPERATOR_MAPINGS.put(FilterParser.COMPARE_OPERATORS[2], CompareFilter.CompareOp.LESS);
        OPERATOR_MAPINGS.put(FilterParser.COMPARE_OPERATORS[3], CompareFilter.CompareOp.GREATER);
        OPERATOR_MAPINGS.put(FilterParser.COMPARE_OPERATORS[4], CompareFilter.CompareOp.LESS_OR_EQUAL);
        OPERATOR_MAPINGS.put(FilterParser.COMPARE_OPERATORS[5], CompareFilter.CompareOp.GREATER_OR_EQUAL);
    }
}

