/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics.gui;

import com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics.JobStatistics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.gui.JLabeledTextField;

public class JobStatisticsGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 1L;
    private JLabeledTextField jobTrackerTextField = null;
    private JLabeledTextField jobTextField = null;
    private JLabeledTextField groupOfCountersNameTextField = null;
    private JCheckBox getJobCountersByIdCheckBox;
    private JCheckBox getJobCountersByIdAndGroupNameCheckBox;
    private JCheckBox getJobStatisticsByJobIdCheckBox;
    private JCheckBox getTaskLevelCountersByJobIdCheckBox;
    private JCheckBox getTaskStatisticsByJobIdCheckBox;

    public JobStatisticsGui() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel panel = new VerticalPanel();
        panel.setBorder(BorderFactory.createEtchedBorder());
        VerticalPanel menuPanel = new VerticalPanel();
        menuPanel.setBorder((Border)BorderFactory.createTitledBorder("Input parameters"));
        this.jobTrackerTextField = new JLabeledTextField("mapred.job.tracker");
        this.jobTextField = new JLabeledTextField("Job Id");
        this.groupOfCountersNameTextField = new JLabeledTextField("Job Counters Group");
        menuPanel.add((Component)this.jobTrackerTextField);
        menuPanel.add((Component)this.jobTextField);
        menuPanel.add((Component)this.groupOfCountersNameTextField);
        VerticalPanel jobStatsPanel = new VerticalPanel();
        jobStatsPanel.setBorder((Border)BorderFactory.createTitledBorder("Job stats"));
        ButtonGroup jobStatsGroup = new ButtonGroup();
        this.getJobCountersByIdCheckBox = new JCheckBox("Get Job Counters By Job Id");
        this.getJobCountersByIdAndGroupNameCheckBox = new JCheckBox("Get Job Counters By Job Id And Group Name");
        this.getJobStatisticsByJobIdCheckBox = new JCheckBox("Get Job Stats By Job Id");
        jobStatsGroup.add(this.getJobCountersByIdCheckBox);
        jobStatsGroup.add(this.getJobCountersByIdAndGroupNameCheckBox);
        jobStatsGroup.add(this.getJobStatisticsByJobIdCheckBox);
        this.registerCheckBoxForItemListener(this.getJobCountersByIdAndGroupNameCheckBox);
        jobStatsPanel.add((Component)this.getJobCountersByIdCheckBox);
        jobStatsPanel.add((Component)this.getJobCountersByIdAndGroupNameCheckBox);
        jobStatsPanel.add((Component)this.getJobStatisticsByJobIdCheckBox);
        VerticalPanel taskStatsPanel = new VerticalPanel();
        taskStatsPanel.setBorder((Border)BorderFactory.createTitledBorder("Task stats"));
        this.getTaskLevelCountersByJobIdCheckBox = new JCheckBox("Get Task Level Counters By Job Id");
        this.getTaskStatisticsByJobIdCheckBox = new JCheckBox("Get Task Stats By Job Id");
        jobStatsGroup.add(this.getTaskLevelCountersByJobIdCheckBox);
        jobStatsGroup.add(this.getTaskStatisticsByJobIdCheckBox);
        taskStatsPanel.add((Component)this.getTaskLevelCountersByJobIdCheckBox);
        taskStatsPanel.add((Component)this.getTaskStatisticsByJobIdCheckBox);
        panel.add((Component)menuPanel);
        panel.add((Component)jobStatsPanel);
        panel.add((Component)taskStatsPanel);
        this.add((Component)panel, "Center");
        if (this.getJobCountersByIdAndGroupNameCheckBox.isSelected()) {
            this.groupOfCountersNameTextField.setEnabled(true);
        }
    }

    public void registerCheckBoxForItemListener(JCheckBox checkBox) {
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JobStatisticsGui.this.groupOfCountersNameTextField.setEnabled(true);
                } else if (e.getStateChange() == 2) {
                    JobStatisticsGui.this.groupOfCountersNameTextField.setEnabled(false);
                }
            }
        });
    }

    public void clearGui() {
        super.clearGui();
        this.jobTrackerTextField.setText("");
        this.jobTextField.setText("");
        this.groupOfCountersNameTextField.setText("");
        this.groupOfCountersNameTextField.setEnabled(false);
        this.getJobCountersByIdCheckBox.setSelected(true);
        this.getJobCountersByIdAndGroupNameCheckBox.setSelected(false);
        this.getJobStatisticsByJobIdCheckBox.setSelected(false);
        this.getTaskLevelCountersByJobIdCheckBox.setSelected(false);
        this.getTaskStatisticsByJobIdCheckBox.setSelected(false);
    }

    public TestElement createTestElement() {
        JobStatistics jobStats = new JobStatistics();
        this.modifyTestElement((TestElement)jobStats);
        return jobStats;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JobStatistics) {
            JobStatistics jobStats = (JobStatistics)element;
            jobStats.setJobTracker(this.jobTrackerTextField.getText());
            jobStats.setJobId(this.jobTextField.getText());
            jobStats.setJobIdAndGroup(this.groupOfCountersNameTextField.getText());
            jobStats.setJobCountersByIdBool(this.getJobCountersByIdCheckBox.isSelected());
            jobStats.setJobCountersByIdAndGroupBool(this.getJobCountersByIdAndGroupNameCheckBox.isSelected());
            jobStats.setJobStatisticsByIdBool(this.getJobStatisticsByJobIdCheckBox.isSelected());
            jobStats.setTaskCountersByIdBool(this.getTaskLevelCountersByJobIdCheckBox.isSelected());
            jobStats.setTaskStatisticsByIdBool(this.getTaskStatisticsByJobIdCheckBox.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JobStatistics) {
            JobStatistics jobStats = (JobStatistics)element;
            this.jobTrackerTextField.setText(jobStats.getJobTracker());
            this.jobTextField.setText(jobStats.getJobId());
            this.groupOfCountersNameTextField.setText(jobStats.getJobIdAndGroup());
            this.getJobCountersByIdCheckBox.setSelected(jobStats.isJobCountersByIdBool());
            this.getJobCountersByIdAndGroupNameCheckBox.setSelected(jobStats.isJobCountersByIdAndGroupBool());
            this.getJobStatisticsByJobIdCheckBox.setSelected(jobStats.isJobStatisticsByIdBool());
            this.getTaskLevelCountersByJobIdCheckBox.setSelected(jobStats.isTaskCountersByIdBool());
            this.getTaskStatisticsByJobIdCheckBox.setSelected(jobStats.isTaskStatisticsByIdBool());
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return "Hadoop Job Tracker Sampler";
    }
}

