/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.hadooputilities.jobstatistics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;

public class JobLayer {
    private static final long serialVersionUID = 1L;
    private String jobId = "";
    private String jobTracker = "";
    private String jobState = "";
    private String groupName = "";

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobTracker() {
        return this.jobTracker;
    }

    public void setJobTracker(String jobTracker) {
        this.jobTracker = jobTracker;
    }

    public String getJobState() {
        return this.jobState;
    }

    public void setJobState(String jobState) {
        this.jobState = jobState;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public JobClient prepareJobClient(String jobTracker) throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapred.job.tracker", jobTracker);
        JobConf jobConf = new JobConf(conf);
        JobClient client = new JobClient(jobConf);
        return client;
    }

    public JobID convertToJobId(String jobId) {
        String id = jobId.replace("job_", "");
        return new JobID(id.split("_")[0], Integer.valueOf(id.split("_")[1]).intValue());
    }

    public String getCountersAsXml(Map<String, String> jobCounters) throws IOException {
        StringBuilder stBuilder = new StringBuilder();
        stBuilder.append("<counters>\n");
        for (Map.Entry<String, String> entry : jobCounters.entrySet()) {
            stBuilder.append(" <counter name=\"" + entry.getKey() + "\" value=\"" + entry.getValue() + "\"/>\n");
        }
        stBuilder.append("</counters>\n");
        return stBuilder.toString();
    }

    public Map<String, String> getJobCounters(String jobTracker, String jobId) throws IOException {
        JobClient client = this.prepareJobClient(jobTracker);
        JobID id = this.convertToJobId(jobId);
        HashMap<String, String> counters = new HashMap<String, String>();
        RunningJob job = client.getJob(id);
        Counters counter = job.getCounters();
        Iterator iter = counter.iterator();
        if (!this.getGroupName().equalsIgnoreCase("")) {
            while (iter.hasNext()) {
                Counters.Group group = (Counters.Group)iter.next();
                if (!group.getDisplayName().equalsIgnoreCase(this.getGroupName())) continue;
                for (Counters.Counter c : group) {
                    counters.put(c.getDisplayName(), String.valueOf(c.getValue()));
                }
            }
        } else {
            while (iter.hasNext()) {
                Counters.Group group = (Counters.Group)iter.next();
                for (Counters.Counter c : group) {
                    counters.put(c.getDisplayName(), String.valueOf(c.getValue()));
                }
            }
        }
        return counters;
    }

    public Map<String, String> getJobCountersByJobId(String jobTracker, String jobId) throws IOException {
        return this.getJobCounters(jobTracker, jobId);
    }

    public Map<String, String> getJobCountersByJobIdAndGroupName(String jobTracker, String jobId, String groupName) throws IOException {
        this.setGroupName(groupName);
        return this.getJobCounters(jobTracker, jobId);
    }

    public String getJobStatisticsByJobId(String jobTracker, String jobId) throws IOException {
        StringBuilder jobStatistics = new StringBuilder();
        JobClient client = this.prepareJobClient(jobTracker);
        JobID id = this.convertToJobId(jobId);
        RunningJob job = client.getJob(id);
        double mapProgress = job.mapProgress() * 100.0f;
        double reduceProgress = job.reduceProgress() * 100.0f;
        String mapPercentage = Double.toString(mapProgress) + "%";
        String reducePercentage = Double.toString(reduceProgress) + "%";
        jobStatistics.append("<job id='" + jobId + "'" + " name='" + job.getJobName() + "'>\n");
        jobStatistics.append(" <mapProgress>" + mapPercentage + "</mapProgress>\n");
        jobStatistics.append(" <reduceProgress>" + reducePercentage + "</reduceProgress>\n");
        jobStatistics.append(" <complete>" + job.isComplete() + "</complete>\n");
        jobStatistics.append(" <successful>" + job.isSuccessful() + "</successful>\n");
        jobStatistics.append(" <url>" + job.getTrackingURL() + "</url>\n");
        jobStatistics.append("</job>");
        return jobStatistics.toString();
    }
}

