/*
 * JRowsSelectorPanel.java
 *
 * Created on Dec 29, 2010, 2:09:35 AM
 */

package kg.apc.jmeter.graphs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JPanel;
import kg.apc.jmeter.JMeterPluginsUtils;

/**
 *
 * @author Stephane Hoblingre
 */
class JRowsSelectorPanel extends javax.swing.JPanel implements GraphRendererInterface {

    GraphPanel parent = null;

    /** Creates new form JRowsSelectorPanel */
    public JRowsSelectorPanel(GraphPanel parent) {
       this.parent = parent;
       initComponents();
    }

    public void setTable(Component table)
    {
        jPanelRowsTable.add(table, BorderLayout.CENTER);
    }

    public void refreshPreview()
    {
        parent.getGraphObject().invalidateCache();
        jPanelGraphPreview.invalidate();
        jPanelGraphPreview.repaint();
    }

    public String getIncludeSampleLabels() {
        return jTextFieldInclude.getText();
    }

    public void setIncludeSampleLabels(String str) {
        jTextFieldInclude.setText(str);
    }

    public String getExcludeSampleLabels() {
        return jTextFieldExclude.getText();
    }

    public void setExcludeSampleLabels(String str) {
        jTextFieldExclude.setText(str);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelLogo = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jPanelMain = new javax.swing.JPanel();
        jPanelRowsTable = new javax.swing.JPanel();
        jPanelRowsConfig = new javax.swing.JPanel();
        jLabelInclude = new javax.swing.JLabel();
        jTextFieldInclude = new javax.swing.JTextField();
        jLabelExclude = new javax.swing.JLabel();
        jTextFieldExclude = new javax.swing.JTextField();
        jPanelGraphPreview = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();

        setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        setLayout(new java.awt.BorderLayout());

        jPanelLogo.setLayout(new java.awt.GridBagLayout());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/kg/apc/jmeter/vizualizers/logoSimple.png"))); // NOI18N
        jLabel1.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        jLabel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanelLogo.add(jLabel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanelLogo.add(jPanel1, gridBagConstraints);

        add(jPanelLogo, java.awt.BorderLayout.PAGE_END);

        jPanelMain.setLayout(new java.awt.GridBagLayout());

        jPanelRowsTable.setLayout(new java.awt.BorderLayout());

        jPanelRowsConfig.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jPanelRowsConfig.setLayout(new java.awt.GridBagLayout());

        jLabelInclude.setText("Include sample labels:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanelRowsConfig.add(jLabelInclude, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 2, 0, 2);
        jPanelRowsConfig.add(jTextFieldInclude, gridBagConstraints);

        jLabelExclude.setText("Exclude sample labels:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanelRowsConfig.add(jLabelExclude, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanelRowsConfig.add(jTextFieldExclude, gridBagConstraints);

        jPanelRowsTable.add(jPanelRowsConfig, java.awt.BorderLayout.SOUTH);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelMain.add(jPanelRowsTable, gridBagConstraints);

        jPanelGraphPreview.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanelMain.add(jPanelGraphPreview, gridBagConstraints);

        jLabel2.setText("Preview:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelMain.add(jLabel2, gridBagConstraints);

        add(jPanelMain, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jLabel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel1MouseClicked
        if((evt.getModifiers() & InputEvent.BUTTON1_MASK) == InputEvent.BUTTON1_MASK)
        {
            JMeterPluginsUtils.openInBrowser("http://code.google.com/p/jmeter-plugins/?utm_source=jmeter&utm_medium=logolink&utm_campaign=row_selector");
        }
    }//GEN-LAST:event_jLabel1MouseClicked


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabelExclude;
    private javax.swing.JLabel jLabelInclude;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanelGraphPreview;
    private javax.swing.JPanel jPanelLogo;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JPanel jPanelRowsConfig;
    private javax.swing.JPanel jPanelRowsTable;
    private javax.swing.JTextField jTextFieldExclude;
    private javax.swing.JTextField jTextFieldInclude;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getGraphDisplayPanel()
    {
        return jPanelGraphPreview;
    }

    @Override
    public boolean isPreview()
    {
        return true;
    }

}
