package kg.apc.jmeter.functions;

import kg.apc.jmeter.modifiers.FifoMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;

/**
 *
 * @author undera
 */
public class FifoPut extends AbstractFunction {

    private static final List<String> desc = new LinkedList<String>();
    private static final String KEY = "__fifoPut";

    static {
        desc.add("Queue name to put value");
        desc.add("String value to put into FIFO queue");
    }
    private Object[] values;

    /**
     * No-arg constructor.
     */
    public FifoPut() {
        FifoMap.getInstance().clear();
    }

    /**
     * {
     *
     * @inheritDoc}
     */
    @Override
    public synchronized String execute(SampleResult previousResult, Sampler currentSampler)
            throws InvalidVariableException {
        String fifoName = ((CompoundVariable) values[0]).execute();
        String value = ((CompoundVariable) values[1]).execute();
        try {
            FifoMap.getInstance().put(fifoName, value);
        } catch (InterruptedException ex) {
            value = "INTERRUPTED";
        }

        return value;
    }

    /**
     * {
     *
     * @inheritDoc}
     */
    @Override
    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        checkMinParameterCount(parameters, 2);
        values = parameters.toArray();
    }

    /**
     * {
     *
     * @inheritDoc}
     */
    @Override
    public String getReferenceKey() {
        return KEY;
    }

    /**
     * {
     *
     * @inheritDoc}
     */
    @Override
    public List<String> getArgumentDesc() {
        return desc;
    }
}
