/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class TransactionsPerSecondGui
extends AbstractOverTimeVisualizer {
    private static String labelAggSuccess = "Successful Transactions per Second";
    private static String labelAggFailure = "Failed Transactions per Second";

    public TransactionsPerSecondGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Number of transactions /sec");
    }

    private void addTransaction(boolean isSuccess, String rowName, long time, double count) {
        String rowAggName;
        String realRowName;
        if (isSuccess) {
            realRowName = rowName + " (success)";
            rowAggName = labelAggSuccess;
        } else {
            realRowName = rowName + " (failure)";
            rowAggName = labelAggFailure;
        }
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(realRowName);
        AbstractGraphRow rowAgg = (AbstractGraphRow)this.modelAggregate.get(rowAggName);
        if (row == null) {
            row = this.getNewRow(this.model, 4, realRowName, 2, false, false, false, true, true);
        }
        if (rowAgg == null) {
            rowAgg = this.getNewRow(this.modelAggregate, 4, rowAggName, 2, false, false, false, true, isSuccess ? Color.GREEN : Color.RED, true);
        }
        if (this.getGranulation() > 0) {
            double tps = count * 1000.0 / (double)this.getGranulation();
            row.add(time, tps);
            rowAgg.add(time, tps);
            if (isSuccess) {
                rowAgg = (AbstractGraphRow)this.modelAggregate.get(labelAggFailure);
                if (rowAgg == null) {
                    rowAgg = this.getNewRow(this.modelAggregate, 4, labelAggFailure, 2, false, false, false, true, Color.RED, true);
                }
                rowAgg.add(time, 0.0);
            }
        }
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Transactions per Second");
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        if (res.isSuccessful()) {
            this.addTransaction(true, res.getSampleLabel(), this.normalizeTime(res.getEndTime()), 1.0);
        } else {
            this.addTransaction(false, res.getSampleLabel(), this.normalizeTime(res.getEndTime()), 1.0);
        }
        this.updateGui(null);
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 2971);
    }

    public String getWikiPage() {
        return "TransactionsPerSecond";
    }
}

