/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.graphs.SettingsInterface;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class ConnectTimesOverTimeGui
extends AbstractOverTimeVisualizer {
    public ConnectTimesOverTimeGui() {
        this.graphPanel.getGraphObject().setYAxisLabel("Connect time in ms");
    }

    private void addThreadGroupRecord(String threadGroupName, long time, long numThreads) {
        String labelAgg = "Overall Connect Times";
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        AbstractGraphRow rowAgg = (AbstractGraphRow)this.modelAggregate.get(labelAgg);
        if (row == null) {
            row = this.getNewRow(this.model, 0, threadGroupName, 2, false, false, false, true, true);
        }
        if (rowAgg == null) {
            rowAgg = this.getNewRow(this.modelAggregate, 0, labelAgg, 2, false, false, false, true, Color.RED, true);
        }
        row.add(time, (double)numThreads);
        rowAgg.add(time, (double)numThreads);
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel((String)"Connect Times Over Time");
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        long connTime = res.getConnectTime();
        if (this.isFromTransactionControler(res)) {
            SampleResult[] subResults;
            for (SampleResult subResult : subResults = res.getSubResults()) {
                connTime += subResult.getConnectTime();
            }
        }
        this.addThreadGroupRecord(res.getSampleLabel(), this.normalizeTime(res.getEndTime()), connTime);
        this.updateGui(null);
    }

    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel((SettingsInterface)this, 2971);
    }

    public String getWikiPage() {
        return "ConnectTimeOverTime";
    }
}

