/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.text.DecimalFormatSymbols;
import kg.apc.charting.rows.GraphRowAverages;
import kg.apc.charting.rows.GraphRowOverallAverages;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractVsThreadVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.gui.NumberRenderer;
import org.apache.jorphan.gui.RateRenderer;

public class ThroughputVsThreadsGui
extends AbstractVsThreadVisualizer {
    public ThroughputVsThreadsGui() {
        this.graphPanel.getGraphObject().setyAxisLabelRenderer((NumberRenderer)new CustomRateRenderer("#.0"));
        this.graphPanel.getGraphObject().setYAxisLabel("Number of estimated transactions /sec");
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Transaction Throughput vs Threads");
    }

    @Override
    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        long time = res.getTime();
        if (time < 1L) {
            return;
        }
        super.add(res);
        String label = res.getSampleLabel();
        String averageLabel = "Average " + res.getSampleLabel();
        GraphRowAverages row = (GraphRowAverages)this.model.get(label);
        GraphRowOverallAverages avgRow = (GraphRowOverallAverages)this.model.get(averageLabel);
        if (row == null || avgRow == null) {
            row = (GraphRowAverages)this.getNewRow(this.model, 0, label, 2, false, false, false, true, false);
            avgRow = (GraphRowOverallAverages)this.getNewRow(this.model, 2, averageLabel, 4, false, true, false, false, row.getColor(), false);
        }
        int allThreads = this.getCurrentThreadCount(res);
        double throughput = (double)allThreads * 1000.0 / (double)time;
        row.add(allThreads, throughput);
        avgRow.add(allThreads, throughput);
        this.graphPanel.getGraphObject().setCurrentX(allThreads);
        this.updateGui(null);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 582);
    }

    @Override
    public String getWikiPage() {
        return "TransactionThroughputVsThreads";
    }

    private static class CustomRateRenderer
    extends RateRenderer {
        private String zeroLabel = "0" + new DecimalFormatSymbols().getDecimalSeparator() + "0/sec";

        public CustomRateRenderer(String format) {
            super(format);
        }

        public void setValue(Object value) {
            if (value != null && value instanceof Double && (Double)value == 0.0) {
                this.setText(this.zeroLabel);
            } else {
                super.setValue(value);
            }
        }
    }
}

