/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.jmxmon;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.ConnectException;
import java.util.Hashtable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.remote.JMXConnector;
import kg.apc.jmeter.jmxmon.JMXMonConnectionPool;
import kg.apc.jmeter.jmxmon.JMXMonSampleGenerator;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JMXMonSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private String metricName;
    private String objectName;
    private String attribute;
    private String key;
    private String url;
    private final JMXMonConnectionPool pool;
    private final Hashtable connectionAttributes;
    private MBeanServerConnection remote;
    private boolean sampleDeltaValue = true;
    private double oldValue = Double.NaN;
    private boolean canRetry = true;
    private boolean hasFailed = false;

    public JMXMonSampler(MBeanServerConnection remote, JMXConnector jmxConnector, String url, String name, String objectName, String attribute, String key, boolean sampleDeltaValue) {
        this.pool = null;
        this.connectionAttributes = null;
        this.remote = remote;
        this.metricName = name;
        this.url = url;
        this.objectName = objectName;
        this.attribute = attribute;
        this.sampleDeltaValue = sampleDeltaValue;
        this.key = key;
        this.canRetry = false;
    }

    public JMXMonSampler(JMXMonConnectionPool pool, Hashtable attributes, String url, String name, String objectName, String attribute, String key, boolean sampleDeltaValue, boolean canRetry) {
        this.pool = pool;
        this.connectionAttributes = attributes;
        this.metricName = name;
        this.url = url;
        this.objectName = objectName;
        this.attribute = attribute;
        this.sampleDeltaValue = sampleDeltaValue;
        this.key = key;
        this.canRetry = canRetry;
    }

    public void generateSamples(JMXMonSampleGenerator collector) {
        try {
            double val;
            if (this.hasFailed && !this.canRetry) {
                return;
            }
            ObjectName beanName = new ObjectName(this.objectName);
            MBeanServerConnection activeRemote = null;
            if (this.remote == null) {
                activeRemote = this.pool.getConnection(this.url, this.connectionAttributes);
                if (activeRemote == null) {
                    this.hasFailed = true;
                }
            } else {
                activeRemote = this.remote;
            }
            if (activeRemote != null) {
                Object o = activeRemote.getAttribute(beanName, this.attribute);
                if (o instanceof CompositeDataSupport) {
                    if (this.key == null || "".equals(this.key)) {
                        log.error("Got composite object from JMX, but no key specified ");
                        return;
                    }
                    CompositeDataSupport cds = (CompositeDataSupport)o;
                    val = Double.parseDouble(cds.get(this.key).toString());
                } else {
                    if (this.key != null && !this.key.equals("")) {
                        log.error("key specified, but didnt get composite object from JMX. Will continue anyway.");
                    }
                    val = Double.parseDouble(o.toString());
                }
            } else {
                val = 0.0;
            }
            if (this.sampleDeltaValue) {
                if (!Double.isNaN(this.oldValue)) {
                    collector.generateSample(val - this.oldValue, this.metricName);
                }
                this.oldValue = val;
            } else {
                collector.generateSample(val, this.metricName);
            }
        }
        catch (MalformedURLException ex) {
            log.error(ex.getMessage());
        }
        catch (ConnectException ex) {
            log.warn("Connection lost", (Throwable)ex);
            this.pool.notifyConnectionDirty(this.url);
            if (this.sampleDeltaValue) {
                if (!Double.isNaN(this.oldValue)) {
                    collector.generateSample(0.0 - this.oldValue, this.metricName);
                }
                this.oldValue = 0.0;
            } else {
                collector.generateSample(0.0, this.metricName);
            }
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
        }
        catch (ReflectionException ex) {
            log.error(ex.getMessage());
        }
        catch (MalformedObjectNameException ex) {
            log.error(ex.getMessage());
        }
        catch (NullPointerException ex) {
            log.error(ex.getMessage());
        }
        catch (MBeanException ex) {
            log.error(ex.getMessage());
        }
        catch (AttributeNotFoundException ex) {
            log.error(ex.getMessage());
        }
        catch (InstanceNotFoundException ex) {
            log.error(ex.getMessage());
        }
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isSampleDeltaValue() {
        return this.sampleDeltaValue;
    }

    public void setSampleDeltaValue(boolean sampleDeltaValue) {
        this.sampleDeltaValue = sampleDeltaValue;
    }

    public double getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(double oldValue) {
        this.oldValue = oldValue;
    }
}

