/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.emulators;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import kg.apc.emulators.FileLockEmul;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FileChannelEmul
extends FileChannel {
    private ByteBuffer writtenBytes;
    private ByteBuffer bytesToRead;
    private static final Logger log = LoggingManager.getLoggerForClass();

    public FileChannelEmul() {
        log.debug("Creating file channel emulator");
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        ByteBuffer chunk;
        if (this.bytesToRead == null || this.bytesToRead.remaining() == 0) {
            log.debug("No more data to read");
            return -1;
        }
        int cnt = dst.capacity() < this.bytesToRead.capacity() ? dst.capacity() : this.bytesToRead.capacity();
        if (cnt < (chunk = this.bytesToRead.duplicate()).capacity()) {
            log.debug("Setting limit to " + cnt);
            chunk.limit(cnt);
        }
        log.debug("Emulating read: " + this.getString(chunk));
        chunk.rewind();
        dst.put(chunk);
        this.bytesToRead = null;
        return cnt;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        log.debug("Emulating write: " + this.getString(src));
        this.writtenBytes = src;
        return src.capacity();
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ByteBuffer getWrittenBytes() {
        ByteBuffer res = this.writtenBytes;
        this.writtenBytes = null;
        return res;
    }

    public void setBytesToRead(ByteBuffer wrap) {
        log.debug("Set bytes to read: " + this.getString(wrap));
        this.bytesToRead = wrap;
    }

    private String getString(ByteBuffer src) {
        if (src == null) {
            log.error("Null buffer!");
            return "";
        }
        return FileChannelEmul.byteBufferToString(src);
    }

    public static String byteBufferToString(ByteBuffer buf) {
        byte[] dst = FileChannelEmul.byteBufferToByteArray(buf);
        return new String(dst);
    }

    public static byte[] byteBufferToByteArray(ByteBuffer buf) {
        ByteBuffer str = buf.duplicate();
        str.rewind();
        byte[] dst = new byte[str.limit()];
        str.get(dst);
        return dst;
    }

    @Override
    public long position() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long size() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void force(boolean metaData) throws IOException {
        log.debug("Force flush");
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return new FileLockEmul();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void implCloseChannel() throws IOException {
        log.debug("Emulating close file channel");
    }
}

