/*
 * Decompiled with CFR 0.152.
 */
package jfun.util.yield;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jfun.util.yield.AbstractContinuation;
import jfun.util.yield.Continuation;
import jfun.util.yield.DiscontinuedException;
import jfun.util.yield.Iterable;

public final class Continuator
implements Iterator {
    private final Control consumer = new Control();
    private final Result producer = new Result();
    private final Iterable iterable;
    private final Continuation y = new AbstractContinuation(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void yield(Object o) {
            ((Continuator)Continuator.this).producer.hasResult = true;
            ((Continuator)Continuator.this).producer.val = o;
            Control control = Continuator.this.consumer;
            synchronized (control) {
                Continuator.this.consumer.signal();
            }
            try {
                if (!Continuator.this.producer.proceed()) {
                    throw new DiscontinuedException();
                }
            }
            catch (InterruptedException e) {
                throw new DiscontinuedException();
            }
        }
    };
    private final Thread background;
    private int cursor;

    public Continuator(Iterable it) {
        this.iterable = it;
        this.cursor = 0;
        this.background = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Continuator.this.iterable.iterate(Continuator.this.y);
                }
                catch (DiscontinuedException discontinuedException) {
                }
                finally {
                    ((Continuator)Continuator.this).producer.done = true;
                    Continuator.this.consumer.finish();
                }
            }
        };
        this.background.setDaemon(true);
        this.background.start();
    }

    public boolean hasNext() {
        try {
            this.consumer.attempt();
        }
        catch (InterruptedException e) {
            return false;
        }
        return !this.producer.done;
    }

    public Object next() {
        try {
            if (!this.consumer.proceed()) {
                throw new NoSuchElementException();
            }
        }
        catch (InterruptedException e) {
            throw new NoSuchElementException();
        }
        Result result = this.producer;
        synchronized (result) {
            if (!this.producer.done) {
                this.producer.hasResult = false;
                ++this.cursor;
                this.producer.signal();
                return this.producer.val;
            }
            throw new NoSuchElementException();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        this.producer.finish();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Continuator) {
            Continuator other = (Continuator)obj;
            return this.cursor == other.cursor && this.iterable.equals(other.iterable);
        }
        return false;
    }

    public int hashCode() {
        return this.iterable.hashCode() * 31 + this.cursor;
    }

    public String toString() {
        return this.iterable.toString() + "[" + this.cursor + "]";
    }

    private static final class Result
    extends Control {
        boolean hasResult = false;
        Object val;

        private Result() {
        }
    }

    private static class Control {
        private boolean go = false;
        boolean done = false;

        private Control() {
        }

        final synchronized boolean proceed() throws InterruptedException {
            while (!this.go && !this.done) {
                this.wait();
            }
            this.go = false;
            return !this.done;
        }

        final synchronized void attempt() throws InterruptedException {
            while (!this.go && !this.done) {
                this.wait();
            }
        }

        final void signal() {
            this.go = true;
            this.notify();
        }

        final synchronized void finish() {
            this.done = true;
            this.notifyAll();
        }
    }
}

