/*
 * Decompiled with CFR 0.152.
 */
package jfun.util.beans;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jfun.util.Misc;
import jfun.util.beans.NoSuchPropertyException;
import jfun.util.beans.PropertyNotWritableException;

public final class BeanType
implements Serializable {
    private transient HashMap props;
    private final Class type;
    private static final WeakHashMap beans = new WeakHashMap();
    private static PropertyDescriptor[] object_properties = BeanType.getObjectClassProperties();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.props = BeanType.getProperties(this.type);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Class getType() {
        return this.type;
    }

    public Set getPropertyNames() {
        return Collections.unmodifiableSet(this.props.keySet());
    }

    public static synchronized BeanType instance(Class type) throws IntrospectionException {
        BeanType cb = (BeanType)beans.get(type);
        if (cb == null) {
            cb = new BeanType(type, BeanType.getProperties(type));
            beans.put(type, cb);
        }
        return cb;
    }

    private BeanType(Class type, HashMap props) {
        this.type = type;
        this.props = props;
    }

    private static HashMap getProperties(Class type) throws IntrospectionException {
        HashMap props = new HashMap();
        if (type.isInterface()) {
            BeanType.populateProperties(object_properties, props);
        }
        BeanInfo info = Introspector.getBeanInfo(type);
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        BeanType.populateProperties(pds, props);
        return props;
    }

    private static PropertyDescriptor[] getObjectClassProperties() throws IllegalStateException {
        try {
            return Introspector.getBeanInfo(Object.class).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("failed to retrieve properties for java.lang.Object: " + e.getMessage());
        }
    }

    private static void populateProperties(PropertyDescriptor[] pds, Map store) {
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            store.put(pd.getName(), pd);
        }
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return (PropertyDescriptor)this.props.get(name);
    }

    public Class getPropertyType(String name) throws NoSuchPropertyException {
        return this.obtainPropertyDescriptor(name).getPropertyType();
    }

    public Class getPropertySetterType(String name) {
        PropertyDescriptor desc = this.obtainPropertyDescriptor(name);
        return BeanType.getPropertySetterType(desc);
    }

    public Method getPropertySetter(String name) {
        Method mtd = this.getWriter(name);
        if (mtd != null) {
            return mtd;
        }
        return this.getIndexedWriter(name);
    }

    public static Class getPropertySetterType(PropertyDescriptor desc) {
        if (desc instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor idesc = (IndexedPropertyDescriptor)desc;
            return Misc.getArrayType(idesc.getIndexedPropertyType());
        }
        return desc.getPropertyType();
    }

    public Class getIndexedPropertyType(String name) throws NoSuchPropertyException {
        PropertyDescriptor desc = this.obtainPropertyDescriptor(name);
        if (desc instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)desc).getIndexedPropertyType();
        }
        throw new NoSuchPropertyException(this.type, name, "indexed property " + name + " cannot be found.");
    }

    public Method getWriter(String name) throws NoSuchPropertyException {
        return this.obtainPropertyDescriptor(name).getWriteMethod();
    }

    public Method getReader(String name) throws NoSuchPropertyException {
        return this.obtainPropertyDescriptor(name).getReadMethod();
    }

    public Method getIndexedWriter(String name) throws NoSuchPropertyException {
        PropertyDescriptor desc = this.obtainPropertyDescriptor(name);
        if (desc instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor idesc = (IndexedPropertyDescriptor)desc;
            return idesc.getIndexedWriteMethod();
        }
        return null;
    }

    public Method getIndexedReader(String name) throws NoSuchPropertyException {
        PropertyDescriptor desc = this.obtainPropertyDescriptor(name);
        if (desc instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor idesc = (IndexedPropertyDescriptor)desc;
            return idesc.getIndexedReadMethod();
        }
        return null;
    }

    private PropertyDescriptor obtainPropertyDescriptor(String name) throws NoSuchPropertyException {
        PropertyDescriptor prop = this.getPropertyDescriptor(name);
        if (prop == null) {
            throw new NoSuchPropertyException(this.type, name);
        }
        return prop;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(Object bean, String name, Object val) throws NoSuchPropertyException, PropertyNotWritableException, InvocationTargetException, IllegalAccessException {
        Method mtd = this.getWriter(name);
        if (mtd == null) {
            if (val != null && !val.getClass().isArray()) {
                throw new PropertyNotWritableException(this.getType(), name);
            }
            Method imtd = this.getIndexedWriter(name);
            if (imtd == null) throw new PropertyNotWritableException(this.getType(), name);
            if (val == null) {
                return;
            }
            if (val instanceof Object[]) {
                Object[] arr = (Object[])val;
                for (int i = 0; i < arr.length; ++i) {
                    imtd.invoke(bean, new Integer(i), arr[i]);
                }
                return;
            } else {
                int sz = Array.getLength(val);
                for (int i = 0; i < sz; ++i) {
                    imtd.invoke(bean, new Integer(i), Array.get(val, i));
                }
            }
            return;
        } else {
            mtd.invoke(bean, val);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeanType) {
            BeanType other = (BeanType)obj;
            return this.type.equals(other.type);
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public String toString() {
        return "bean <" + Misc.getTypeName(this.type) + ">";
    }
}

