/*
 * Decompiled with CFR 0.152.
 */
package jfun.util.beans;

import java.beans.IntrospectionException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jfun.util.beans.BeanType;
import jfun.util.beans.NoSuchPropertyException;
import jfun.util.beans.PropertyNotReadableException;
import jfun.util.beans.PropertyNotWritableException;

public final class Bean
implements Serializable {
    private final Object obj;
    private final BeanType btype;

    public Object getObject() {
        return this.obj;
    }

    public BeanType getBeanType() {
        return this.btype;
    }

    public Object getProperty(String name) throws NoSuchPropertyException, PropertyNotReadableException, InvocationTargetException, IllegalAccessException {
        Method mtd = this.btype.getReader(name);
        if (mtd == null) {
            throw new PropertyNotReadableException(this.btype.getType(), name);
        }
        return mtd.invoke(this.obj, null);
    }

    public Bean setProperty(String name, Object val) throws NoSuchPropertyException, PropertyNotWritableException, InvocationTargetException, IllegalAccessException {
        this.btype.setProperty(this.obj, name, val);
        return this;
    }

    public Object getProperty(String name, int ind) throws NoSuchPropertyException, PropertyNotReadableException, InvocationTargetException {
        try {
            Method mtd = this.btype.getIndexedReader(name);
            if (mtd == null) {
                throw new PropertyNotReadableException(this.btype.getType(), name);
            }
            return mtd.invoke(this.obj, new Integer(ind));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Bean setProperty(String name, int ind, Object val) throws NoSuchPropertyException, PropertyNotWritableException, InvocationTargetException {
        try {
            Method mtd = this.btype.getIndexedWriter(name);
            if (mtd == null) {
                throw new PropertyNotWritableException(this.btype.getType(), name);
            }
            mtd.invoke(this.obj, new Integer(ind), val);
            return this;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Bean(Object obj, BeanType bean) {
        this.obj = obj;
        this.btype = bean;
    }

    public static Bean instance(Object obj) throws IntrospectionException {
        return new Bean(obj, BeanType.instance(obj.getClass()));
    }

    public static Bean instance(Class type, Object obj) throws IntrospectionException {
        return Bean.instance(BeanType.instance(type), obj);
    }

    public static Bean instance(BeanType btype, Object obj) {
        return new Bean(obj, btype);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Bean) {
            Bean other = (Bean)obj;
            return this.btype.equals(other.btype) && Bean.eq(obj, other.obj);
        }
        return false;
    }

    public int hashCode() {
        return this.btype.hashCode() * 31 + this.obj.hashCode();
    }

    public String toString() {
        return this.btype.toString();
    }

    private static boolean eq(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }
}

