/*
 * Decompiled with CFR 0.152.
 */
package jfun.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import jfun.util.ConsList;
import jfun.util.NilList;
import jfun.util.Sizeable;

public abstract class List
implements Sizeable,
Serializable {
    public static final List nil = new NilList();

    public abstract boolean isEmpty();

    public abstract Object head();

    public abstract List tail();

    public List rev() {
        return this.revAppend(nil);
    }

    public abstract List revAppend(List var1);

    public abstract int size();

    public List cons(Object obj) {
        return new ConsList(obj, this);
    }

    public int hashCode() {
        int hcode = 0;
        int len = this.size();
        List l = this;
        for (int i = 0; i < len; ++i) {
            Object hd = l.head();
            hcode = hcode * 31 + (hd == null ? 0 : hd.hashCode());
            l = l.tail();
        }
        return hcode;
    }

    public boolean equals(Object other) {
        if (other instanceof List) {
            List l = (List)other;
            int sz = this.size();
            if (l.size() != sz) {
                return false;
            }
            List a = this;
            List b = l;
            for (int i = 0; i < sz; ++i) {
                Object o1 = a.head();
                Object o2 = b.head();
                if (!(o1 != null ? o1.equals(o2) : o2 == null)) {
                    return false;
                }
                a = a.tail();
                b = b.tail();
            }
            return true;
        }
        return false;
    }

    public String toString() {
        int sz = this.size();
        if (sz == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.head());
        List l = this.tail();
        for (int i = 1; i < sz; ++i) {
            buf.append(',').append(l.head());
            l = l.tail();
        }
        buf.append("]");
        return buf.toString();
    }

    public void toList(java.util.List to) {
        int sz = this.size();
        List l = this;
        for (int i = 0; i < sz; ++i) {
            to.add(l.head());
            l = l.tail();
        }
    }

    public Object[] toArray() {
        int sz = this.size();
        Object[] ret = new Object[sz];
        return this.toArray(ret);
    }

    public Object[] toArray(Object[] arr) {
        return this.toArray(0, arr);
    }

    public Object[] toArray(int from, Object[] arr) {
        int sz = this.size();
        List l = this;
        for (int i = from; i < sz + from; ++i) {
            arr[i] = l.head();
            l = l.tail();
        }
        return arr;
    }

    public Object[] revArray() {
        int sz = this.size();
        Object[] ret = new Object[sz];
        return this.revArray(ret);
    }

    public Object[] revArray(Object[] arr) {
        return this.revArray(0, arr);
    }

    public Object[] revArray(int from, Object[] arr) {
        int sz = this.size();
        List l = this;
        for (int i = sz + from - 1; i >= from; --i) {
            arr[i] = l.head();
            l = l.tail();
        }
        return arr;
    }

    public static List fromArray(Object[] arr) {
        List l = nil;
        for (int i = arr.length - 1; i >= 0; --i) {
            l = l.cons(arr[i]);
        }
        return l;
    }

    public static List fromArray(Object arr) {
        if (arr instanceof Object[]) {
            return List.fromArray((Object[])arr);
        }
        List l = nil;
        int size = Array.getLength(arr);
        for (int i = size - 1; i >= 0; --i) {
            l = l.cons(Array.get(arr, i));
        }
        return l;
    }
}

