/*
 * Decompiled with CFR 0.152.
 */
package jfun.loader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import jfun.loader.Definer;
import jfun.loader.Loader;
import jfun.util.CollectionUtils;

final class InheritedLoader
implements Loader {
    private final ClassLoader parent;
    private final Loader child;

    InheritedLoader(ClassLoader parent, Loader child) {
        this.child = child;
        this.parent = parent;
    }

    public Class lookupClass(String name, Definer definer) throws ClassNotFoundException {
        try {
            return this.parent.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return this.child.lookupClass(name, definer);
        }
    }

    public URL lookupResource(String name) {
        URL url = this.parent.getResource(name);
        if (url == null) {
            url = this.child.lookupResource(name);
        }
        return url;
    }

    public Enumeration enumerateResources(String name) throws IOException {
        return CollectionUtils.append(this.parent.getResources(name), this.child.enumerateResources(name));
    }
}

